define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		//***** FUNCTIONS ******//
		

	module("#528/1198 - Informational text on message count - Clerk");
	
	test("#1539 Validate the informational message text above the msg text box", function() {
		asyncSeries(function(){
			if ($('#appointmentRequestTable').is(':visible')) {
				ok($("#appointmentRequestTable").is(":visible"),
				"Appointment Requests table is displayed");
				}
			
				return 1000;
				
			}, function() {
				ok($('.ui-title').is(':visible'),
				"Title is visible");

			//Then I can see the header info
				ok($('.ui-title:contains("Veteran Appointments")').text(),
					"Then I can see Veteran Appointments on the title bar");
			//Go to request details and validate the information text
				$("#appointmentRequestTable tr:nth-child(5)").mousedown().click();
				
			}, function() {
				ok($('#content-primary').is(':visible'),'Request details is visible');
			//Validate the new informational text displayed above the message text box
			}, function() {
				equal($("#content-primary div:nth-child(1):contains('This exchange is limited to four (4) messages. If you need additional information, please call the Clinic.')").
						length >0,true,'Informational message text exists');
				
			
			
				
				});
		});
	

	module("#528/1069 - Implement VAAC messaging business rules");
	
	test("#1540 Validate Business rules on limiting user from sending messages - Clerk side", function() {
		asyncSeries(function(){
			if ($('#appointmentRequestTable').is(':visible')) {
				ok($("#appointmentRequestTable").is(":visible"),
				"Appointment Requests table is displayed");
				}
			
				return 1000;
				
			}, function() {
				ok($('.ui-title').is(':visible'),
				"Title is visible");

			//Then I can see the header info
				ok($('.ui-title:contains("Veteran Appointments")').text(),
					"Then I can see Veteran Appointments on the title bar");
				
			//Validate the message in the text box for Cancelled request
				ok($("#appointmentRequestTable tr:nth-child(5)").mousedown().click(),'Click on Cancelled request','Cancelled request details');
				ok($("#newMessage").find('input').eq(0).trigger('click'),'Click on new message text field','Clicked on message text box');
			}, function() {
				ok($("#newMessage").attr("placeholder"),'Appointment has been cancelled',
				'Appointment cancelled');
			//Send button is disabled
			}, function() {
				equal($("#sendMessage").attr("aria-disabled"),"true",'Send button disabled');
				
			
			//Validate the message text box that not more than 2 messages cannot be sent.
				ok($("#appointmentRequestTable tr:nth-child(2)").mousedown().click(),'Click on Not Booked request','Not Booked request details');
				ok($("#newMessage").find('input').eq(0).trigger('click'),'Click on new message text field','Clicked on message text box');
			}, function() {
				ok($("#newMessage").attr("placeholder"),"Can't send more than two messages...",
				'Cannot send more than 2 messages');
			//Send button is disabled
			}, function() {
				equal($("#sendMessage").attr("aria-disabled"),"true",'Send button disabled');
			
			//Validate the message text box that you have to wait for a response after initiating a message.
				ok($("#appointmentRequestTable tr:nth-child(1)").mousedown().click(),'Click on Submitted request','Submitted request details');
				ok($("#newMessage").find('input').eq(0).trigger('click'),'Click on new message text field','Clicked on message text box');
			}, function() {
				ok($("#newMessage").attr("placeholder"),'Must wait for response before sending another message',
				'Must wait to respond after initiating msg');
			//Send button is disabled
			}, function() {
				equal($("#sendMessage").attr("aria-disabled"),"true",'Send button disabled');
			
		});
	});
});

