define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {		
		
	module("#1781/1785 - Ability - Clerk");
	
	test("#1795 Validate the sorting by Alert column", function() {
		asyncSeries(function(){
			if ($('#appointmentRequestTable').is(':visible')) {
				ok($("#appointmentRequestTable").is(":visible"),
				"Appointment Requests table is displayed");
				}
			
				return 1000;
				
			}, function() {
				ok($('.ui-title').is(':visible'),
				"Title is visible");

			//Then I can see the header info
				ok($('.ui-title:contains("Veteran Appointments")').text(),
					"Then I can see Veteran Appointments on the title bar");
			},
			defaultSortOrder,
			
			//sort by Alert column - descending
			function () {
				ok($("#appointmentRequestTable th:nth-child(1)").trigger('click'),'Alert column clicked','Requests sorted by Alert column-descending');			
			}, 
			
			//Validate that the request with the new message icon is displayed in the first row.
			function validateFirstARIsWithNewMessageIcon() {
				equal($('#appointmentRequestTable tr:nth-child(1) i:nth-child(1).fonticon.chat.new-message').is(':visible'),true,
						'New message icon exists');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(2)').text(),'patient66','Row1-Lastname');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(3)').text(),'zztest','Row1-Firstname');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(4)').text(),'DC VAMC','Row1-Facility');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(5)').text(),'Primary Care','Row1-Type');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(6)').text(),'Booked','Row1-Status');
				//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row5-Last Activity date');	
			}, 
			
			//sort by Alert column - ascending
			function () {
				ok($("#appointmentRequestTable th:nth-child(1)").trigger('click'),'Alert column clicked','Requests sorted by Alert column-ascending');			
			},
			
			//Validate that the request with the new message icon is displayed in the last row.
			function validateLastARIsWithNewMessageIcon () {
				equal($('#appointmentRequestTable tr:nth-child(5) i:nth-child(1).fonticon.chat.new-message').is(':visible'),true,
						'New message icon exists');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(2)').text(),'patient66','Row5-Lastname');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(3)').text(),'zztest','Row5-Firstname');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(4)').text(),'DC VAMC','Row5-Facility');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(5)').text(),'Primary Care','Row5-Type');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(6)').text(),'Booked','Row5-Status');
				//equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(7)').text(),today,'Row5-Last Activity date');	
			}, 
			
			//**************************************************************
			//Click on Restore Default Sort Order button 
			clickRestoreDefaultSortOrderButton,
			//validate the default sort	
			defaultSortOrder,				
			//**************************************************************
			
			//No Sort by LastName, FirstName and Facility as the same data exists for the test data
			
			//Sort by Type - Ascending
			function () {
				ok($("#appointmentRequestTable th:nth-child(5)").trigger('click'),'Type column clicked','Requests sorted by Type column-ascending');			
			}, 
			
			//Validate that the request list based on the current sort
			function () {
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(5)').text(),'Mental Health','Row1-Type');
				equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(5)').text(),'Mental Health','Row2-Type');
				equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(5)').text(),'Primary Care','Row3-Type');
				equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(5)').text(),'Primary Care','Row4-Type');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(5)').text(),'Primary Care','Row5-Type');			
			}, 
			
			//**************************************************************
			//Click on Restore Default Sort Order button 
			clickRestoreDefaultSortOrderButton,
			//validate the default sort	
			defaultSortOrder,	
			//**************************************************************	
	
			//Sort by Status - Ascending
			function () {
				ok($("#appointmentRequestTable th:nth-child(6)").trigger('click'),'Status column clicked','Requests sorted by Status column-ascending');			
			}, 
			
			//Validate that the request list based on the current sort
			function () {
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(6)').text(),'Booked','Row1-Type');
				equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(6)').text(),'Cancelled','Row2-Type');
				equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(6)').text(),'Not Booked','Row3-Type');
				equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(6)').text(),'Submitted','Row4-Type');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(6)').text(),'Submitted','Row5-Type');			
			}, 
			
			//**************************************************************
			//Click on Restore Default Sort Order button 
			clickRestoreDefaultSortOrderButton,
			//validate the default sort	
			defaultSortOrder,		
			//**************************************************************	
		
			//Sort by Last Activity - descending
			function () {
				ok($("#appointmentRequestTable th:nth-child(7)").trigger('click'),'Last Activity column clicked','Requests sorted by Last Activity column-ascending');
				ok($("#appointmentRequestTable th:nth-child(7)").trigger('click'),'Last Activity column clicked','Requests sorted by Last Activity column-descending');
						
			
			}, 
			//Validate that the request list based on the current sort
			function () {
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),'03/17/2013 05:00:00','Row1-Type');
				equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(7)').text(),'03/17/2013 04:00:00','Row2-Type');
				equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(7)').text(),'03/17/2013 03:00:00','Row3-Type');
				equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(7)').text(),'03/17/2013 02:00:00','Row4-Type');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(7)').text(),'03/17/2013 01:00:00','Row5-Type');			
			}, 
			
			//**************************************************************
			//Click on Restore Default Sort Order button 
			clickRestoreDefaultSortOrderButton,
			//validate the default sort	
			defaultSortOrder		
			//**************************************************************	
		);
	});
	
	//***** FUNCTIONS ******//
	
	function defaultSortOrder() {
		//1st Row
		equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(2)').text(),'patient66','Row1-Lastname');
		equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(3)').text(),'zztest','Row1-Firstname');
		equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(4)').text(),'DC VAMC','Row1-Facility');
		equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(5)').text(),'Primary Care','Row1-Type');
		equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(6)').text(),'Submitted','Row1-Status');
		//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row1-Last Activity date');
	
		//2nd Row
		equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(2)').text(),'patient66','Row2-Lastname');
		equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(3)').text(),'zztest','Row2-Firstname');
		equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(4)').text(),'DC VAMC','Row2-Facility');
		equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(5)').text(),'Mental Health','Row2-Type');
		equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(6)').text(),'Submitted','Row2-Status');
		//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row1-Last Activity date');
		
		//3rd Row
		equal($('#appointmentRequestTable tr:nth-child(3) i:nth-child(1).fonticon.chat.new-message').is(':visible'),true,
				'New message icon exists');
		equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(2)').text(),'patient66','Row3-Lastname');
		equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(3)').text(),'zztest','Row3-Firstname');
		equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(4)').text(),'DC VAMC','Row3-Facility');
		equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(5)').text(),'Primary Care','Row3-Type');
		equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(6)').text(),'Booked','Row3-Status');
		//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row1-Last Activity date');
		
		//4th Row
		equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(2)').text(),'patient66','Row4-Lastname');
		equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(3)').text(),'zztest','Row4-Firstname');
		equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(4)').text(),'DC VAMC','Row4-Facility');
		equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(5)').text(),'Primary Care','Row4-Type');
		equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(6)').text(),'Not Booked','Row4-Status');
		//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row1-Last Activity date');
	
		//5th Row
		equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(2)').text(),'patient66','Row5-Lastname');
		equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(3)').text(),'zztest','Row5-Firstname');
		equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(4)').text(),'DC VAMC','Row5-Facility');
		equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(5)').text(),'Mental Health','Row5-Type');
		equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(6)').text(),'Cancelled','Row5-Status');
		//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row1-Last Activity date');
	}
	
	function clickRestoreDefaultSortOrderButton() {
		ok($("#restore-sort-btn").trigger('tap'),'Restore Default Sort Order button clicked','Rows displayed as per default sort');		
	}
});

