define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		//***** FUNCTIONS ******//
	
	module("#1577/1708 - Alert column sortable for Appointment Requests - Clerk");
	
	test("#1741 Validate the sorting by Alert column", function() {
		asyncSeries(function(){
			if ($('#appointmentRequestTable').is(':visible')) {
				ok($("#appointmentRequestTable").is(":visible"),
				"Appointment Requests table is displayed");
				}
			
				return 1000;
				
			}, function() {
				ok($('.ui-title').is(':visible'),
				"Title is visible");

			//Then I can see the header info
				ok($('.ui-title:contains("Veteran Appointments")').text(),
					"Then I can see Veteran Appointments on the title bar");
			
			//First Row
			}, function firstRow() {
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(2)').text(),'patient66','Row1-Lastname');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(3)').text(),'zztest','Row1-Firstname');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(4)').text(),'DC VAMC','Row1-Facility');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(5)').text(),'Primary Care','Row1-Type');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(6)').text(),'Submitted','Row1-Status');
				//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row1-Last Activity date');
		
			//Second Row
			}, function secondRow() {
				equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(2)').text(),'patient66','Row2-Lastname');
				equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(3)').text(),'zztest','Row2-Firstname');
				equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(4)').text(),'DC VAMC','Row2-Facility');
				equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(5)').text(),'Mental Health','Row2-Type');
				equal($('#appointmentRequestTable tr:nth-child(2) td:nth-child(6)').text(),'Submitted','Row2-Status');
				//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row1-Last Activity date');
				
			//Third Row
			}, function thirdRow() {
				equal($('#appointmentRequestTable tr:nth-child(3) i:nth-child(1).fonticon.chat.new-message').is(':visible'),true,
						'New message icon exists');
				equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(2)').text(),'patient66','Row3-Lastname');
				equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(3)').text(),'zztest','Row3-Firstname');
				equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(4)').text(),'DC VAMC','Row3-Facility');
				equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(5)').text(),'Primary Care','Row3-Type');
				equal($('#appointmentRequestTable tr:nth-child(3) td:nth-child(6)').text(),'Booked','Row3-Status');
				//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row1-Last Activity date');
				
			
			//Fourth Row
			}, function fourthRow() {
				equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(2)').text(),'patient66','Row4-Lastname');
				equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(3)').text(),'zztest','Row4-Firstname');
				equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(4)').text(),'DC VAMC','Row4-Facility');
				equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(5)').text(),'Primary Care','Row4-Type');
				equal($('#appointmentRequestTable tr:nth-child(4) td:nth-child(6)').text(),'Not Booked','Row4-Status');
				//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row1-Last Activity date');
			
			//Fifth Row
			}, function fifthRow() {
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(2)').text(),'patient66','Row5-Lastname');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(3)').text(),'zztest','Row5-Firstname');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(4)').text(),'DC VAMC','Row5-Facility');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(5)').text(),'Mental Health','Row5-Type');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(6)').text(),'Cancelled','Row5-Status');
				//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row1-Last Activity date');
				
			//sort by Alert column - ascending
			}, function () {
				ok($("#appointmentRequestTable th:nth-child(1)").trigger('click'),'Alert column clicked','Requests sorted by Alert column-ascending');
			
			//Validate that the request with the new message icon is displayed in the first row.
			}, function () {
				equal($('#appointmentRequestTable tr:nth-child(1) i:nth-child(1).fonticon.chat.new-message').is(':visible'),true,
						'New message icon exists');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(2)').text(),'patient66','Row1-Lastname');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(3)').text(),'zztest','Row1-Firstname');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(4)').text(),'DC VAMC','Row1-Facility');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(5)').text(),'Primary Care','Row1-Type');
				equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(6)').text(),'Booked','Row1-Status');
				//equal($('#appointmentRequestTable tr:nth-child(1) td:nth-child(7)').text(),today,'Row5-Last Activity date');
			
			//sort by Alert column - descending
			}, function () {
				ok($("#appointmentRequestTable th:nth-child(1)").trigger('click'),'Alert column clicked','Requests sorted by Alert column-descending');
			
			//Validate that the request with the new message icon is displayed in the last row.
			}, function () {
				equal($('#appointmentRequestTable tr:nth-child(5) i:nth-child(1).fonticon.chat.new-message').is(':visible'),true,
						'New message icon exists');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(2)').text(),'patient66','Row5-Lastname');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(3)').text(),'zztest','Row5-Firstname');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(4)').text(),'DC VAMC','Row5-Facility');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(5)').text(),'Primary Care','Row5-Type');
				equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(6)').text(),'Booked','Row5-Status');
				//equal($('#appointmentRequestTable tr:nth-child(5) td:nth-child(7)').text(),today,'Row5-Last Activity date');
		});
	});
});

