define([
	'jQuery',
	'async'
], function(jQuery, async) {
	var $$ = jQuery.noConflict(true), myFrame = $$("#myFrame"), setup = function() {
		var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;

		require( ['1529', '1522', '1517', '1518', '1528'] );

		$$(document).ready(function() { 
			start(); 
		});

		QUnit.testStart(function() {
			stop();
			myFrame.attr('src', referencePath + '../../reprohealth')
				.on("load", function() {
					//grab jQuery from inside the document
					$ = jQuery = myFrame[0].contentWindow.jQuery;

					//turn off async so tests will wait for ajax results
					$.ajaxSetup({ async: false });

					$.getScript(referencePath + "../jquery.simulate.js");

					//turn off animations so they do not break tests
					$.support.cssTransitions = false;
					$.fx.off = true;
					QUnit.start();
				});
		});
	};

	return {
		initialize: setup
	};
});
