define([
    'jQuery',
    'asyncSeries'
], function ($$, asyncSeries) {

  module("#1529/#AcceptanceCriteria Tests for Pregnancy Care Content");
  // var myFrame = $$('#myFrame');
                  
  //***** FUNCTIONS ******//
  function pregnancyCarePage(next) {
    var $listView = $('ul.ui-listview li'); // for faster access, reduce search
    ok($('h1:contains("Pregnancy Care")').is(":visible"), "Navigated to Pregnancy Care");
    async.map( ['Primary Care Visits','Primary Care Visits','Early Pregnancy Health','Prenatal Care Event','Postpartum Care'], function(label){
        ok($listView.find(label), label+" link visible");
    });
  }
  function matchLinkWithHeader( headerLink ) {
    setTimeout( function() { //this timeout is to keep all in one function
      start();    
      ok($('h1:contains("'+headerLink+'")').is(':visible'), headerLink+" header is visible");
      //QUnit.stop();
    }, 100);
    ok(true, "navigating to "+headerLink);
    stop();
    $('ul.ui-listview li').find('a:contains("'+headerLink+'")').trigger('click');
  }
  function goBack(){
    var $back = $('.back');
    ok($back.is(':visible'), "go back");
    $back.trigger('click');
  }
  //***** TESTS *****//

  test("#TestId Navigate to ReproHealthGuide app", function () {
    asyncSeries(
      function () {
        ok($('h1:contains("ReproHealthGuide")').is(":visible"), "ReproHealthGuide header is visible");
        ok($('a:contains("Pregnancy Care")').is(":visible"), "Link to Pregnancy Care is visible");
        $('a:contains("Pregnancy Care")').trigger("click");
      },
      pregnancyCarePage,
      ////Primary Care Visits//////////// 
      function () {
        matchLinkWithHeader("Primary Care Visits");
        return 210;
      },
      function(){
        $('.ui-collapsible-heading-status').click();
      },
      function(){
        ok( $(".ui-collapsible-content:contains('Check immunization status')").is(':visible'),
          "first Colapsible content is visible");
        ok( $(".ui-collapsible-content:contains('Intimate Partner Violence')").is(':visible'),
          "second Colapsible content is visible");
      },
      goBack, pregnancyCarePage,
      ////Early Pregnancy Health Evaluations//////////// 
      function () {
        matchLinkWithHeader("Early Pregnancy Health Evaluation");
        return 210;
      }, 
        ////////////////Sub Menus /////////////////////////
        //////////////////////////Reasons for Immediate Referral///////////////
        function(){
          matchLinkWithHeader("Reasons for Immediate Referral");
          return 210;
        }, goBack,
        //////////////////////////Vaccination///////////////
        function(){
          matchLinkWithHeader("Vaccination");
          return 210;
        }, goBack,
        //////////////////////////Risk Factor Assessment///////////////
        function(){
          matchLinkWithHeader("Risk Factor Assessment");
          return 210;
        }, goBack,
        //////////////////////////Education and Risk Minimization///////////////
        function(){
          matchLinkWithHeader("Education and Risk Minimization");
          return 210;
        }, goBack,
        //////////////////////////Prenatal Laboratory Assessment///////////////
        function(){
          matchLinkWithHeader("Prenatal Laboratory Assessment");
          return 210;
        }, goBack,
      goBack, pregnancyCarePage,
      ////Prenatal Care Event Timeline//////////// 
      function () {
        matchLinkWithHeader("Prenatal Care Event Timeline");
        return 210;
      }, 
        ////////////////Sub Menus /////////////////////////
        //////////////////////////12 Weeks Gestation///////////////
        function(){
          matchLinkWithHeader("12 Weeks Gestation");
          return 210;
        }, goBack,
        //////////////////////////Every Prenatal Visit///////////////
        function(){
          matchLinkWithHeader("Every Prenatal Visit");
          return 210;
        }, goBack,
        //////////////////////////28 Weeks Gestation///////////////
        function(){
          matchLinkWithHeader("28 Weeks Gestation");
          return 210;
        }, goBack,
        //////////////////////////36 Weeks Gestationn///////////////
        function(){
          matchLinkWithHeader("36 Weeks Gestation");
          return 210;
        }, goBack,
        //////////////////////////42 Weeks Gestation///////////////
        function(){
          matchLinkWithHeader("42 Weeks Gestation");
          return 210;
        }, goBack,
      goBack, pregnancyCarePage,
      ///Postpartum Care and Care//////////// 
      function () {
        matchLinkWithHeader("Postpartum Care and Care");
        return 210;
      }, 
        ////////////////Sub Menus /////////////////////////
        //////////////////////////Delivery Care///////////////
        function(){
          matchLinkWithHeader("Delivery Care");
          return 210;
        }, goBack,
        //////////////////////////Postpartum Visits///////////////
        function(){
          matchLinkWithHeader("Postpartum Visits");
          return 210;
        }, goBack,
        //////////////////////////Postpartum Coordination///////////////
        function(){
          matchLinkWithHeader("Postpartum Coordination");
          return 210;
        }, goBack,
      goBack, pregnancyCarePage
    );
  });
});