define([
	'jQuery',
	'asyncSeries'
], function ($$, asyncSeries) {
	module("#1528/#Pregnancy Care Section Page Content");

	/**
	* Functions
	* @returns {undefined}
	*/

	/**
	* Individual Tests
	* @returns {undefined} 
	*/
	test("#TestId Preconception Page content is present on page and correct", function () {
		asyncSeries(
			function () {
				var $PregnancyCareLink = $('a:contains("Pregnancy Care")');
				ok($('h1:contains("ReproHealthGuide")').is(":visible"), "ReproHealthGuide header is visible");
				ok($PregnancyCareLink.is(":visible"), "Link to pregnancy care is visible");
				$PregnancyCareLink.trigger('click');// go to page.
			},
			function () {
				// Check if header is visible and contains proper text
				ok($('h1:contains("Pregnancy Care")').is(":visible"), "Pregnancy Care header is visible");
				// Check if each navigation link is visible and contains proper text
				ok($('a:contains("Pregnancy-Related Primary Care Visits")').is(":visible"), "Pregnancy-Related Primary Care Visits button is visible and contains correct text.");
				ok($('a:contains("Early Pregnancy Health Evaluation and Risk Assessment")').is(":visible"), "Early Pregnancy Health Evaluation and Risk Assessment button is visible and contains correct text.");
				ok($('a:contains("Prenatal Care Event Timeline by Gestational Age")').is(":visible"), "Prenatal Care Event Timeline by Gestational Age button is visible and contains correct text.");
				ok($('a:contains("Postpartum Care and Care Coordination with VA")').is(":visible"), "Postpartum Care and Care Coordination with VA button is visible and contains correct text.");
				// Check that the paragraph text exists
				ok($('p:contains("VA")').is(":visible"), "Paragraph text is visible.");
			}
		);
	});
});