define([
    'jQuery',
    'asyncSeries'
], function ($$, asyncSeries) {

    module("#1522/#AcceptanceCriteria Tests for Family Genetic History And Risk");

    //***** FUNCTIONS ******//
    function familyGenericPage() {
        // in page
        var $listView = $('ul.ui-listview li'); // for faster access, reduce search
        ok($('h1:contains("Family"):contains("Genetic")').is(":visible"), "Family Genetic History & Risk sub section of Preconception Topics header is visible");
        ok($listView.find('a:contains("Caucasian European")').is(":visible"), "Caucasian European link is visible");
        ok($listView.find('a:contains("Ashkenazi Jewish")').is(":visible"), "Ashkenazi Jewish link is visible");
        ok($listView.find('a:contains("French-Canadian")').is(":visible"), "French-Canadian link is visible");
        ok($listView.find('a:contains("Cajun")').is(":visible"), "Cajun link is visible");
        ok($listView.find('a:contains("African")').is(":visible"), "African link is visible");
        ok($listView.find('a:contains("Mediterranean")').is(":visible"), "Mediterranean link is visible");
        ok($listView.find('a:contains("Asian")').is(":visible"), "Asian link is visible");
    }


    //***** TESTS *****//

    test("#TestId Navigate to Family Genetic History", function () {
        asyncSeries(
            function () {
                var $PreconCareLink = $('a:contains("Preconception Care")');
                ok($('h1:contains("ReproHealthGuide")').is(":visible"), "ReproHealthGuide header is visible");
                ok($PreconCareLink.is(":visible"), "Link to preconception care is visible");
                $PreconCareLink.trigger('click');// go to page.
            },
			function() {
				var $FamilyGeneticLink = $('a:contains("Genetic History")');
                ok($('h1:contains("Preconception Care")').is(":visible"), "Preconception Care header is visible");
                ok($FamilyGeneticLink.is(":visible"), "Link to family/genetic history & risk is visible");
                $FamilyGeneticLink.trigger('click');// go to page.
			},
            familyGenericPage,
            //////////////////////Caucasian European////////////
            function () {
                $('ul.ui-listview li').find('a:contains("Caucasian European")').trigger('click');
                ok(true, "navigating to Caucasian European");
            },
            function () {
                ok($('h1:contains("Caucasian European")').is(':visible'), "Caucasian European header is visible");
                var $back = $('.back');
                ok($back.is(':visible'), "go back");
                $back.trigger('click');
            },
            familyGenericPage,
            ///////////////////////////Ashkenazi Jewish////////////
            function () {
                $('ul.ui-listview li').find('a:contains("Ashkenazi Jewish")').trigger('click');
                ok(true, "navigating to - Ashkenazi Jewish");
            },
            function () {
                ok($('h1:contains("Ashkenazi Jewish")').is(':visible'), "Ashkenazi Jewish - header is visible");
                var $back = $('.back');
                ok($back.is(':visible'), "go back");
                $back.trigger('click');
            },
            familyGenericPage,
            /////////////////////French-Canadian/////////////////
            function () {
                $('ul.ui-listview li').find('a:contains("French-Canadian")').trigger('click');
                ok(true, "navigating to - French-Canadian");
            },
            function () {
                ok($('h1:contains("French")').is(':visible'), "French-Canadian - header is visible");
                var $back = $('.back');
                ok($back.is(':visible'), "go back");
                $back.trigger('click');
            },
            familyGenericPage,
            ////////////////////Cajun////////////////////
            function () {
                $('ul.ui-listview li').find('a:contains("Cajun")').trigger('click');
                ok(true, "navigating to - Cajun");
            },
            function () {
                ok($('h1:contains("Cajun")').is(':visible'), "Cajun - header is visible");
                var $back = $('.back');
                ok($back.is(':visible'), "go back");
                $back.trigger('click');
            },
            familyGenericPage,
            ////////////////African//////////////////
            function () {
                $('ul.ui-listview li').find('a:contains("African")').trigger('click');
                ok(true, "navigating to - African");
            },
            function () {
                ok($('h1:contains("African")').is(':visible'), "African - header is visible");
                var $back = $('.back');
                ok($back.is(':visible'), "go back");
                $back.trigger('click');
            },
            familyGenericPage,
            ///////////////Mediterranean//////////////////
            function () {
                $('ul.ui-listview li').find('a:contains("Mediterranean")').trigger('click');
                ok(true, "navigating to - Mediterranean");
            },
            function () {
                ok($('h1:contains("Mediterranean")').is(':visible'), "Mediterranean - header is visible");
                var $back = $('.back');
                ok($back.is(':visible'), "go back");
                $back.trigger('click');
            },
            familyGenericPage,
            //////////////////Asian/////////////////////
            function () {
                $('ul.ui-listview li').find('a:contains("Asian")').trigger('click');
                ok(true, "navigating to - Asian");
            },
            function () {
                ok($('h1:contains("Asian")').is(':visible'), "Asian - header is visible");
                var $back = $('.back');
                ok($back.is(':visible'), "go back");
                $back.trigger('click');
            },
            familyGenericPage
        );
    });
});