define([
	'jQuery',
	'asyncSeries'
], function ($$, asyncSeries) {
	module("#1518/#Preconception Care Section Page Content");

	/**
	* Functions
	* @returns {undefined}
	*/

	/**
	* Individual Tests
	* @returns {undefined} 
	*/
	test("#TestId Preconception Page content is present on page and correct", function () {
		asyncSeries(
			function () {
				var $PreconCareLink = $('a:contains("Preconception Care")');
				ok($('h1:contains("ReproHealthGuide")').is(":visible"), "ReproHealthGuide header is visible");
				ok($PreconCareLink.is(":visible"), "Link to preconception care is visible");
				$PreconCareLink.trigger('click');// go to page.
			},
			function () {
				// Check if header is visible and contains proper text
				ok($('h1:contains("Preconception Care")').is(":visible"), "Preconception Care header is visible");
				// Check if each navigation link is visible and contains proper text
				ok($('a:contains("Reproductive Life Plan")').is(":visible"), "Reproductive Life Plan button is visible and contains correct text.");
				ok($('a:contains("Birth Control Methods")').is(":visible"), "Birth Control Methods button is visible and contains correct text.");
				ok($('a:contains("Concurrent Health Issues")').is(":visible"), "Concurrent Health Issues button is visible and contains correct text.");
				ok($('a:contains("Family/Genetic History & Risk")').is(":visible"), "Family/Genetic History & Risk button is visible and contains correct text.");
				ok($('a:contains("Lifestyle Factors Checklist")').is(":visible"), "Lifestyle Factors Checklist button is visible and contains correct text.");
				ok($('a:contains("Medication Use & Risk Mitigation")').is(":visible"), "Medication Use & Risk Mitigation button is visible and contains correct text.");
				ok($('a:contains("Men & Preconception Health")').is(":visible"), "Men & Preconception Health button is visible and contains correct text.");
				ok($('a:contains("Reproductive History")').is(":visible"), "Reproductive History button is visible and contains correct text.");
				ok($('a:contains("Vaccinations")').is(":visible"), "Vaccinations button is visible and contains correct text.");
			}
		);
	});
});