define([
	'jQuery',
	'async',
	'common',
	'40008',
	'../modules/36919',
	'../modules/36933',
	'../modules/36948',
	'../modules/36961',
	'../modules/37175',
	'../modules/37353',
	'../modules/39630',
	'../modules/39949',
	'40080',
	'37009',
	'40007',
	'39630',
	'40005',
	'40458'
], function(jQuery, async, commonTests, patientViewer, detailedLabView, detailedLabGraph, labGraphDateRange, medication, labViewer, vitals, summaryView, vitalsGraph, footer, chemHemMicro, summary, patientSummary, medicationDetails, patientIdentifier){

	var $$ = jQuery.noConflict(true),
		myFrame = $$("#myFrame");

	var setup = function(){
		var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;
		defineTests();

		async.series([
			function(next){
				$$(document).ready(function(){
					next();
				});
			},
			function(next){
				myFrame.attr('src', referencePath + '../../logout')
					.one('load', function(){
						next();
					});
			},
			function(next){
				myFrame.attr('src', referencePath + '../../oauthlogin?redirect_uri=' + referencePath + '../../patient-viewer')
					.one('load', function(){
						next();
					});
			},
			function(next){
				afterJqueryLoad(function(){
					//grab jQuery from inside the document
					$ = jQuery = myFrame[0].contentWindow.jQuery;

					$("#name-c").val('zztest.staff01');
					$("#password").val('pass');
					$('#facilityName').val('DC VAMC');
					$('#autocomplete-container input').val('DC VAMC');
					$('#facilityCode').val('688');

					$("#logonForm").submit();
					myFrame.one('load', function(){
						afterJqueryLoad(function(){
							afterOauthTokenInSessionStorage(function(){
								next();
							});
						});
					});
				});
			},
			function(next){
				setTimeout(function(){
					if($('h4:contains("DISCLAIMER")').length === 1){
						$('#accept-btn').trigger('tap');
					}
					next();

				}, 500);
			}
		], function(){
			start();
		});

		QUnit.testStart(function(){
			stop();
			myFrame.off("load");
			myFrame.attr('src', referencePath + '../../patient-viewer')
				.on("load", function(){
					afterJqueryLoad(function(){
						var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;

						//grab jQuery from inside the document
						$ = jQuery = myFrame[0].contentWindow.jQuery;

						//turn off async so tests will wait for ajax results
						$.ajaxSetup({ async: false });

						$.getScript(referencePath + "../jquery.simulate.js");

						//turn off animations so they do not break tests
						$.support.cssTransitions = false;
						$.fx.off = true;

						var started = false;
						var iFrameDocument = myFrame[0].contentDocument ? myFrame[0].contentDocument : (myFrame[0].contentWindow.document || myFrame[0].document);
						
						// workaround for iframe's load event not working properly
						$(iFrameDocument).ready(function() {
							setTimeout(function() {
								if (!started) {
									started = true;
									QUnit.start();
								}
							}, 1000);
						});
						
						// if workaround fails (jquery ready fired before we could register handler), wait 5 seconds and run
						setTimeout(function() {
							if (!started) {
								started = true;
								QUnit.start();
							}
						}, 5000);
					});
				});
		});

	};

	function afterJqueryLoad(callback){
		if(typeof myFrame[0].contentWindow.jQuery === 'undefined'){
			setTimeout(function(){
				afterJqueryLoad(callback);
			}, 50);
		}
		else{
			callback();
		}
	}

	function afterOauthTokenInSessionStorage(callback){
		var token = myFrame[0].contentWindow.sessionStorage.token;
		if(typeof token !== 'undefined' && token && token !== 'null'){
			callback();
		}
		else{
			setTimeout(function(){
				afterOauthTokenInSessionStorage(callback);
			}, 200);
		}
	}

	function waitForElement(callback){
		if($('#patient-search input').length === 0){
			setTimeout(function(){
				$('#footer-patient-search-btn').trigger('tap');
				waitForElement(callback);
			}, 200);
		}
		else{
			callback();
		}
	}

	function defineTests(){
		commonTests.initialize();
		patientViewer.initialize();
		detailedLabView.initialize();
		detailedLabGraph.initialize();
		labGraphDateRange.initialize();
		medication.initialize();
		labViewer.initialize();
		vitals.initialize();
		summaryView.initialize();
		vitalsGraph.initialize();
		footer.initialize();
		chemHemMicro.initialize();
		summary.initialize();
		patientSummary.initialize();
		medicationDetails.initialize();
		patientIdentifier.initialize();
	}

	return {
		initialize: setup
	};
});
