define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#40458 Add patient identifiers to Patient-Viewer app screens");
		test('Patient details appear in title bar', function() {
			searchAndSelectPatient('patient66');
			asyncSeries(function() {
				var patientInfo = $('h3').find('.ui-block-a').text().split(" ");
				equal(patientInfo[0], 'Patient66', 'Patient info shows last name');
				equal(patientInfo[1], '(9966)', 'Patient info shows last 4 digits of ssn');
			});
		});

		test('Full patient detail appear in the footer', function() {
			searchAndSelectPatient('patient66');
			asyncSeries(function() {
				var patientInfo = $('#footer-patientname').text().trim().replace(/\s+/g, " ").split(' - ');
				equal(patientInfo[0], 'patient66, zztest', 'Full patient name is displayed');
				equal(patientInfo[1], 'MALE', 'Patient gender is displayed');
				equal(patientInfo[2], '999-99-9966', 'Patient SSN is displayed');
				equal(patientInfo[3], '01/01/1900', 'Patient DOB is displayed');
				equal(patientInfo[4], '113', 'Patient age is displayed');
			});
		});
	};

	return {
		initialize: defineTests
	};
});
