define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#40080 Dynamic Footer Validation");

		test('A fixed set of buttons is displayed', function() {
			searchAndSelectPatient();
			equal($('#footer .ui-grid-d li').length, '5', 'Verify only 5 buttons are displayed');
			ok($('#footer-menu-popup-popup li').length >= 2, 'Verify the list in the popup is populated');
		});
		
//		test('Verify navigation using the static footer and the pop-up footer', function() {
//			searchAndSelectPatient();
//			asyncSeries(function() {
//				$('#footer-more-btn').trigger('tap');
//			}, function() {
//				$('#footer-vital-signs-btn').trigger('tap');
//				return 1000;
//			}, function() {
//				var heading = $('#content-secondary .ui-header h3').text();
//				equal(heading, 'Vital Signs',
//						'Verify the test is viewing Vital Signs');
//				$('#footer-lab-results-btn').trigger('tap');
//				return 1000;
//			}, function() {
//				heading = $('#content-secondary .ui-header h3').text();
//				equal(heading, 'Lab Results',
//						"Verify the test is viewing Lab Results");
//			});
//		});

		test('Verify that the popup is displayed only after clicking more', function() {
			searchAndSelectPatient();
			ok($('#footer-menu-popup-popup.ui-selectmenu-hidden'), 'The popup is hidden');
			$('#footer-more-btn').trigger('tap'); 
			ok($('#footer-menu-popup-popup.ui-popup-active'), 'The popup is displayed');
			
			$('#footer-lab-results-btn').trigger('tap');
			stop();
			setTimeout(function() {
				start();
				ok($('#footer-menu-popup-popup.ui-selectmenu-hidden'), 
						'The popup is hidden after selecting clicking the footer');
			}, 100);
		});

		
	};
	
	return {
		initialize: defineTests
	};
});
