define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#40008: Patient Viewer");

		function getResultsCount()
		{
			return $('#patient-search-results li a').length;	
		}
		
		function getName()
		{
			return $('#patient-search-results li:nth-child(2) a h3').eq(0).text();
		}

		
		test('Verify that search results are paged at 20 records', function() {

			searchAndSelectPatient('patient26');

			
			var resultLength = getResultsCount();
			equal(resultLength, 20, 'Verify that only 20 rows are displayed');
			equal($('#displayed-result-count').text(), 'Displaying 20 results',
					'Verify the correct count of records is displayed');

			//TODO: The following block has become unstable.  
			//Need to implement consistent mechanism to trigger scrolling
//			var patientSearchHeight = $('#patient-search').height();
//			
//			
//			//Scroll down a couple times to trigger the process to fetch more records
//			asyncSeries(function() {
//				$('#content-secondary .scrollable').scrollTop(patientSearchHeight);
//			}, function() {
//				$('#content-secondary .scrollable').scrollTop(0);
//			}, function() {
//				$('#content-secondary .scrollable').scrollTop(patientSearchHeight);
//			}, function() {
//				$('#content-secondary .scrollable').scrollTop(0);
//				resultLength = getResultsCount();
//				var recordCount = parseInt($('#displayed-result-count').text().substring(11,13), 10);
//				ok(recordCount > 20, 'Verify that there are more records available after scrolling');
//			});

		});

		test('Verify that only one record is returned when searching on last name', function() {
			searchAndSelectPatient('patient66');

			var resultLength = getResultsCount();
			equal(resultLength, 1, 'Verify that only 1 person is displayed');

			var patientName = getName();
			equal(patientName, 'patient66, zztest', 'Verify the name of the returned results');
		});
		
		test('Verify that only one record is returned when searching on SSN', function() {
			searchAndSelectPatient('999999926');
			
			var resultLength = getResultsCount();
			equal(resultLength, 1, 'Verify that only 1 person is displayed');

			var patientName = getName();
			equal(patientName, 'patient26, zztest', 'Verify the name of the returned results');
		});
		
		test('Verify that only one record is returned when searching with last initial and last 4 of SSN', function() {
			searchAndSelectPatient('8989');

			var resultLength = getResultsCount();
			ok(resultLength > 1, 'Verify more than one result is returned');

			$('#patient-search input').val('p9956').trigger('change');
			resultLength = getResultsCount();
			ok(resultLength === 1, 'Verify that only one result is returned');
			
			var patientName = getName();
			equal(patientName, 'patient56, zztest', 'Verify the name of the returned results');
		});

		test('Verify that the person record is highlighted when selected', function() {
			searchAndSelectPatient('testpatient');
			
			var resultLength = getResultsCount();
			ok(resultLength > 1, 'Verify that more than one result is returned');
			
			$('#patient-search-results li:nth-child(3) a').trigger('tap');
			ok($('#patient-search-results li:nth-child(3).ui-btn-active').length === 1,
					'Verify that the person record is highlighted');

		});

		test('Verify that special characters are supported and do not generate errors', function() {
			searchAndSelectPatient("\u070f\u17b4\u17b5!@#$%^&*()_+=-~`");
			
			var resultLength = getResultsCount();
			equal(resultLength, 0, 'Verify that no rows are displayed');
			
			equal($('#patient-search-results li:nth-child(1) span').eq(0).text(),
					'Displaying 0 results', 
					'Verify the text when no results are returned');
			
		});
		
		test('Verify that the system allows searching for names with apostrophes', function() {
			searchAndSelectPatient("patient'69");
			
			var resultLength = getResultsCount();
			equal(resultLength, 1, 'Verify that only row is displayed');
			
			var patientName = getName();
			equal(patientName, "patient'69, zztest", 'Verify the name of the returned results');			
		});
		
		test('Verify that the system allows searching for names with hyphens', function() {
			searchAndSelectPatient("patient-71");
			var resultLength = getResultsCount();
			equal(resultLength, 1, 'Verify that only row is displayed');
			
			var patientName = getName();
			equal(patientName, "patient-71, zztest", 'Verify the name of the returned results');			
		});

		test('Verify that the system allows searching for names with spaces', function() {
			searchAndSelectPatient("patient 70");
			
			var resultLength = getResultsCount();
			equal(resultLength, 1, 'Verify that only row is displayed');
			
			var patientName = getName();
			equal(patientName, "patient 70, zztest", 'Verify the name of the returned results');			
		});

		
	};
	
	return {
		initialize: defineTests
	};
});
