define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#40007: Patient Summary");

		test('Verify the section list within patient summary', function() {
			searchAndSelectPatient("patient66");
			asyncSeries(function() {
				$('#footer-summary-btn').trigger('tap');
				return 500;
			}, function() {
				equal($('#content-secondary li:nth-child(1)').text().trim(), 'Contact Information', 'Verify Contact Information section');
				equal($('#content-secondary li:nth-child(2)').text().trim(), 'Medical Diagnoses', 'Verify Medical Diagnoses section');
				equal($('#content-secondary li:nth-child(3)').text().trim(), 'Allergies', 'Verify Allergies section');
				equal($('#content-secondary li:nth-child(4)').text().trim(), 'Inpatient Meds', 'Verify Inpatient Medications section');
				equal($('#content-secondary li:nth-child(5)').text().trim(), 'Outpatient Meds', 'Verify Outpatient Medications section');
				equal($('#content-secondary li:nth-child(6)').text().trim(), 'Surgeries', 'Verify Surgeries section');
			});
		});
		
		test('Verify the contents of the footer list', function() {
			searchAndSelectPatient("patient66");
			var footerList = $('#footer li');
			var footerPopupList = $('#footer-menu-popup li');
			
			equal($('#footer .ui-grid-d li:nth-child(1) #footer-patient-search-btn').text().trim(), 'Search', 'Verify Search button');
			equal($('#footer .ui-grid-d li:nth-child(2)').text().trim(), 'Summary', 'Verify Summary button');
			equal($('#footer .ui-grid-d li:nth-child(3)').text().trim(), 'Lab Results', 'Verify Lab Results button');
			equal($('#footer .ui-grid-d li:nth-child(4)').text().trim(), 'Vital Signs', 'Verify Vital Signs button');
			equal($('#footer .ui-grid-d li:nth-child(5)').text().trim(), 'More', 'Verify More button');
			equal($('#footer-menu-popup li:nth-child(1)').text().trim(), 'Medications', 'Verify Medications button');
			equal($('#footer-menu-popup li:nth-child(2)').text().trim(), 'Launchpad', 'Verify Logout button');
			equal($('#footer-menu-popup li:nth-child(3)').text().trim(), 'Logout', 'Verify Launchpad button');
			
		});

		test('Verify inpatient medication content', function() {
			searchAndSelectPatient("patient66");
			asyncSeries(function() {
				$('#footer-summary-btn').trigger('tap');
			}, function() {
				equal($('#summary-Inpatient-Medications h2').text(), 'INPATIENT Medications',
						'Verify the heading of the inpatient medications section');
			});
		});

		
		test('Verify outpatient medication content', function() {
			searchAndSelectPatient("patient66");
			asyncSeries(function() {
				$('#footer-summary-btn').trigger('tap');
			}, function() {
				equal($('#outpatientMeds h2').text(), 'OUTPATIENT Medications',
						'Verify the heading of the inpatient medications section');
			});
		});
		
		test('Verify the content of inpatient and outpatient medication sections is different', function() {
			searchAndSelectPatient("patient66");
			asyncSeries(function() {
				$('#footer-summary-btn').trigger('tap');
			}, function() {
				var inpatientMed = $('#inpatientMeds tr:nth-child(5) td:nth-child(1)').contents(':not(span)').text();
				var outpatientMed = $('#outpatientMeds tr:nth-child(5) td:nth-child(1)').contents(':not(span)').text();
				
				ok(inpatientMed != outpatientMed, 'Verify inpatient meds are not the same as outpatient meds');
			});
		});

	};
	
	return {
		initialize: defineTests
	};
});
