define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#40005: Medication Details");
		
		function searchAndSelectPatient(name)
		{
			$('#patient-search input').val(name).trigger('change');
			$('#patient-search-results li:nth-child(2) a').trigger('tap');
		}
		
		function clickFooter()
		{
			$('#footer-more-btn').trigger('tap'); 
			$('#footer-medications-btn').trigger('tap');
		}

		test('Verify medication details', function() {
			searchAndSelectPatient('patient66');
			clickFooter();
			stop();
			setTimeout(function(){
				start();
				$('#content-primary li:first a').trigger('tap');
				equal($('.ui-popup-active h1').text(), '5-fluorouracil', 'Verify the drug name');
				equal($('.ui-popup-active li:nth-child(1) .fieldname').text(), 'Status', 'Verify status');
				equal($('.ui-popup-active li:nth-child(2) .fieldname').text(), 'Instructions', 'Verify Instructions');
				equal($('.ui-popup-active li:nth-child(3) .fieldname').text(), 'Quantity', 'Verify Quantity');
				equal($('.ui-popup-active li:nth-child(4) .fieldname').text(), 'Refills', 'Verify Refills');
				equal($('.ui-popup-active li:nth-child(5) .fieldname').text(), 'Last Filled', 'Verify Last Filled');
				equal($('.ui-popup-active li:nth-child(6) .fieldname').text(), 'Initial Ordered', 'Verify Initial Ordered');
				equal($('.ui-popup-active li:nth-child(7) .fieldname').text(), 'Date Expired', 'Verify Date Expired');
				equal($('.ui-popup-active li:nth-child(8) .fieldname').text(), 'Source', 'Verify Source');
				equal($('.ui-popup-active li:nth-child(9) .fieldname').text(), 'Service', 'Verify Service');
				equal($('.ui-popup-active legend h4').text(), 'Notes', 'Verify notes section');
				ok($('.ui-popup-active pre').text().length, 'Notes section is populated');

				$('.ui-popup-active a').trigger('click');
				ok($('.ui-popup-active').length === 0, 'Verify the popup is no longer displayed');
				
			}, 500);
			

		});


	};
	
	return {
		initialize: defineTests
	};
});
