define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {

	var defineTests = function() {

		module("#39630 Patient Summary Validation");
		
		function getAge(year) {
			var today = new Date();
			var birthDate = new Date(year, 1, 1);
			var age = today.getFullYear() - birthDate.getFullYear();
			return age;
		}
		
		test('Verify the location value for an admitted patient', function() {
			searchAndSelectPatient('patient60');
			expect(1);

			var location = $('#summary-Contact-Information [name="location"]').text().trim();
			equal(location, "7 North, 7A-23", 'Verify the location value');
		});
		
		test('Verify the message when no medical diagnoses exists for the patient', function() {
			searchAndSelectPatient('patient60');

			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var noData = $('#summary-Medical-Diagnoses').contents(':not(h2)').text().trim();
				equal(noData, "No Data Found", 'Verify the message when no medications exist');
			});
		});
		
		test('Verify the message when no Allergies exists for the patient', function() {
			searchAndSelectPatient('patient60');
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var noData = $('#summary-Allergies').contents(':not(h2)').text().trim();
				equal(noData, "No Data Found", 'Verify the message when no allergies exist');
			});
		});
		
		test('Verify the message when no surgeries exists for the patient', function() {
			searchAndSelectPatient('patient60');
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var noData = $('#summary-Surgeries').contents(':not(h2)').text().trim();
				equal(noData, "No Data Found", 'Verify the message when no surgeries exist');
			});
		});
		
		test('Verify the message when no outpatient medications exists for the patient', function() {
			searchAndSelectPatient('patient60');
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var noData = $('#summary-Surgeries').contents(':not(h2)').text().trim();
				equal(noData, "No Data Found", 'Verify the message when no surgeries exist');
			});
		});
		
		test('Verify the format of the DOB and age calculation', function() {
			searchAndSelectPatient('patient57');
			var dob = '1900';
			var age = getAge(1900);
			equal($('#summary-Contact-Information [name="dob"]').text(), dob + ' (' + age + ')', 'Verify the format of DOB and calculated age');
		});
	};
	
	return {
		initialize: defineTests
	};
});
