define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#37009 Microbiology Lab Results");
		
		function clickMicro()
		{
			//$('#tabView .ui-block-b a').trigger('click');
			$('#tabView .ui-block-b a').trigger('tap');
			return 500;
		}
		
		function clickChemHem()
		{
			//$('#tabView .ui-block-a a').trigger('click');
			$('#tabView .ui-block-a a').trigger('tap');
		}
		
		function clickFooterMore()
		{
			$('#footer-more-btn').trigger('tap');
		}
		function clickFooter()
		{
			$('#footer-lab-results-btn').trigger('tap');
			return 500;
		}
		
		test('Verify the message when no chem/hem or microbiology results exist', function() {
			
			searchAndSelectPatient('patient57');
			asyncSeries(clickFooterMore, clickFooter, function() {
				ok($('#tabView .ui-block-b .ui-btn-active'));
			}, clickMicro, function() {
				equal($('#content-secondary li h3').text(), 'No Data Found',
						'Verify that no data found is displayed when no labs exist');
			}, clickChemHem, function() {
				ok($('#tabView .ui-block-a .ui-btn-active'), 'Chem/Hem button is active');
				equal($('#content-secondary li h3').text(), 'No Data Found',
					'Verify that no data found is displayed when no labs exist');
			});
		});
		
		//TODO: Un-comment when story 40004 is implsmented 
//		asyncTest('Verify the list of microbioloby lab results are grouped', function() {
//			searchAndSelectPatient('patient66');
//			clickFooter();
//			setTimeout(function() {
//				start();
//				ok($('#content-secondary .ui-header h3').text(), 'Lab Results');
//				ok($('#tabView .ui-block-b .ui-btn-text').text(), 'Microbiology');
//
//				clickMicro();
//				var afbCount = $('#lab-list div:nth-child(1) li').length;
//				var csCount = $('#lab-list div:nth-child(2)').eq(1).find('li').length;
//				var afbText = $('#lab-list div:nth-child(1) h2 .ui-btn-text').contents(':not(.ui-collapsible-heading-status)').text();
//				var csText = $('#lab-list div:nth-child(2) h2 .ui-btn-text').contents(':not(.ui-collapsible-heading-status)').text();
//				equal(afbText, 'AFB C&S (BLOOD) ('+ afbCount +')', 'Verify the abbreviated lab name in the button text');
//				equal(csText, 'C&S (BLOOD) ('+ csCount +')', 'Verify the abbreviated lab name in the button text');
//				
//			}, 100);
//		});		
		
		test('Lab names are sorted alphabetically', function() {
			searchAndSelectPatient('patient66');
			
			asyncSeries(clickFooterMore, clickFooter, function() {
				ok($('#tabView .ui-block-b .ui-btn-active'));
			}, clickMicro, function() {
				var labsLength = $('#lab-list').children().length;
				ok(labsLength > 0, 'Patient has at least one microbiology lab result');
				
				var labName = $('#lab-list div:nth-child(1) h2 .ui-btn-text').contents(':not(.ui-collapsible-heading-status)').text();
				for (var i = 1; i <= labsLength; i ++) {
					var nextLabName = $('#lab-list div:nth-child('+ i +') h2 .ui-btn-text').contents(':not(.ui-collapsible-heading-status)').text();
						
					ok(labName <= nextLabName, 'Lab name is sorted alphabetically');
					labName = nextLabName;
				}
			});
			
		});

		test('Verify section can be expanded and collapsed', function() {
			searchAndSelectPatient('patient66');
			asyncSeries(clickFooterMore, clickFooter, function() {
				ok($('#tabView .ui-block-b .ui-btn-active'));
			}, clickMicro, function() {
				if(!$('#lab-list div:nth-child(1)').hasClass('ui-collapsible-collapsed')) {
					$('#lab-list div:nth-child(1) h2 a').trigger('click');
				}
			}, function() {
				ok($('#lab-list div:nth-child(1)').hasClass('ui-collapsible-collapsed'), 'Verify that the group is collapsed');
				$('#lab-list div:nth-child(1) h2 a').trigger('click');
			}, function() {
				ok(!$('#lab-list div:nth-child(1)').hasClass('ui-collapsible-collapsed'), 'Verify that the group is expanded');
			});
		});

		test('Verify that only groups for which the patient has results are listed', function() {
			searchAndSelectPatient('patient66');
			asyncSeries(clickFooterMore, clickFooter, function() {
				ok($('#tabView .ui-block-b .ui-btn-active'));
			}, clickMicro, function() {
				var labGroups = $('#lab-list div h2 .ui-btn-text').contents(':not(.ui-collapsible-heading-status):contains(TOXICOLOGY)').length; 
				ok(labGroups === 0,'Verify that TOXICOLOGY is not listed in the lab groups since the patient has no toxicology labs');
			});
		});	
		
		test('Past microbiology labs are sorted in reverse chronological order', function() {
			searchAndSelectPatient('patient66');
			asyncSeries(clickFooterMore, clickFooter, function() {
				ok($('#tabView .ui-block-b .ui-btn-active'));
			}, clickMicro, function() {
				var labsLength = $('#lab-list div:nth-child(1) li').length;
				ok(labsLength > 0, 'Patient has at least one microbiology lab result');
					
				var previousDate = new Date($('#lab-list div:nth-child(1) li:nth-child(1) a h3').text());
				for (var i = 1; i <= labsLength; i ++) {
					var labDate = new Date($('#lab-list div:nth-child(1) li:nth-child(' + i + ') a h3').text()); 
						
					ok(previousDate >= labDate, 'Previous date is greater than or equal to current date (reverse chronological order)');
					previousDate = labDate;
				}
			});
			
		});
		
		//TODO: Un-comment when story 40004 is implsmented
//		asyncTest('Verify the name and date of the lab are listed for AFB C&S', function() {
//			searchAndSelectPatient('patient66');
//			clickFooter();
//			setTimeout(function() {
//				start();
//				clickMicro();
//				var labDate = $('#lab-list div:nth-child(1) li:nth-child(1) a h3').text();
//				var labName = -$('#lab-list div:nth-child(1) li:nth-child(1) p').text().trim();
//				equal(labDate, '09/01/2011', 'Verify the date of the lab is listed in the button');
//				equal(labName, 'Acid-fast Bacillus Culture and Sensitivity', 'Verify the lab name is listed in the button');
//				
//			}, 100);
//		});	
//
//		
//		asyncTest('Verify the name and date of the lab are listed for C&S', function() {
//			searchAndSelectPatient('patient66');
//			clickFooter();
//			setTimeout(function() {
//				start();
//				clickMicro();
//				var labDate = $('#lab-list div:nth-child(1) li:nth-child(1) a h3').text();
//				var labName = $('#lab-list div:nth-child(2) li:nth-child(1) p').eq(1).text().trim();
//				equal(labDate, '09/01/2011', 'Verify the date of the lab is listed in the button');
//				equal(labName, 'Culture and Sensitivity', 'Verify the lab name is listed in the button');
//				
//			}, 100);
//		});		
		
		test('Verify that the labs are scrollable', function() {
			searchAndSelectPatient('patient66');
			
			asyncSeries(clickFooterMore, clickFooter, function() {
				ok($('#tabView .ui-block-b .ui-btn-active'));
			}, clickMicro, function() {
				ok($('#content-secondary div:nth-child(2)').hasClass('scrollable'));
			});
			
		});	
		
		test('Verify that a selected item is highlighted', function() {
			searchAndSelectPatient('patient66');

			asyncSeries(clickFooterMore, clickFooter, function() {
				ok($('#tabView .ui-block-b .ui-btn-active'));
			}, clickMicro, function() {
				$('#lab-list').children().eq(0).find('li:nth-child(1) a').trigger('tap');
				ok($('#lab-list').children().eq(0).find('li:nth-child(2).ui-btn-active'), 
						"The selected lab is highlighted");
				
			});
			
		});	
		
		test('Verify the content for a lab after selecting it', function() {
			searchAndSelectPatient('patient66');

			asyncSeries(clickFooterMore, clickFooter, function() {
				ok($('#tabView .ui-block-b .ui-btn-active'));
			}, clickMicro, function() {
				$('#lab-list div:nth-child(1) li:nth-child(1) a').trigger('tap');
				return 500;
			}, function() {
				equal($('.detail-findings h2').text(), 
						'Microbiology Detailed Report', 
						'Verify the header of the microbiology report');
				ok($(".detail-findings pre:contains('AFB CULTURE & SMEAR')"), 
						'Verify that the contents of the lab contain some value');
			});
		});	
	};
	
	return {
		initialize: defineTests
	};
});
