define([
	'jQuery','async', 'common',
	'95','96','97',
	'98','100', '101',
	'335','398','461',
	'461b', '277', '272'
], function(jQuery, async, commonTests,
		help, learn, desire,
		feel, summary, reflections,
		learnRedesign, saveB4exit, loginRedirect,
		logoutRedirect, priorities, characLimit) {
	var $$ = jQuery.noConflict(true),
	myFrame = $$("#myFrame");
	
	var setup = function() {
		var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;
		defineTests();
		async.series([
			function(next) {
				$$(document).ready(function() { next(); });
			},
			function(next) {
				myFrame.attr('src', referencePath + '../../logout')
					.one('load', function() { next(); });
			},
			function(next) {
				myFrame.attr('src', referencePath + '../../oauthlogin?redirect_uri=' + referencePath + '../../mygoals')
					.one('load', function() { next(); });
			},
			function(next) {
				//grab jQuery from inside the document
				
				$ = jQuery = myFrame[0].contentWindow.jQuery;

				$("#name-c").val('zztest.patient66');
				$("#password").val('pass');

				$("#logonForm").submit();
				myFrame.one('load', function() { next(); });
			}
		], function() {
			start();
		});
		
		QUnit.testStart(function() {
			stop();
			myFrame.attr('src', referencePath + '../../mygoals')
				.on("load", function() {
					//grab jQuery from inside the document
					
					$ = jQuery = myFrame[0].contentWindow.jQuery;

					//turn off async so tests will wait for ajax results
					$.ajaxSetup({ async: false });
					$.getScript(referencePath + "../jquery.simulate.js");

					//turn off animations so they do not break tests
					$.support.cssTransitions = false;
					$.fx.off = true;
					setTimeout(function(){
						if( $.confirm )
						{
							//$.confirm.hide();
							$('.ui-btn-text:contains("ACCEPT")').trigger('click');
						}
					},100);
					
					QUnit.start();

				});
		});
	};

	function defineTests() {
		commonTests.initialize();
		feel.initialize();
		reflections.initialize();
		help.initialize();
		summary.initialize();
		desire.initialize();
		learn.initialize();
		saveB4exit.initialize();
		learnRedesign.initialize();
		//loginRedirect.initialize();
		//logoutRedirect.initialize();
		priorities.initialize();
		characLimit.initialize();
	}
	
	return {
		initialize: setup
	};
});
