define([
	'jQuery'
], function($$) {
	var defineTests = function() {
		function gotoFeel(){
			$('a:contains("How I Feel")').simulate('click');
		}
		module("#98 MyGoals How I feel");
		
		asyncTest("Navigate to how I feel section of the app", function(){
			expect(3);
			ok($('a h3:contains("How I Feel")').is(':visible'), 'feel button is visible');
			gotoFeel();
			//stop();
			setTimeout( function(){
				ok($('h3:contains("How I Feel")').is(':visible'), 'How I Feel page loaded with title');
				equal($('h3.ui-title').text().trim(), 'How I Feel', 'How I Feel" page loaded with title "How I Feel" ');//may be overkill
				start();
			},100);

		});
		asyncTest('Check Saving',8, function() {

			async.series([
				function(next){
					ok($('a:contains("How I Feel")').is(':visible'), 'feel button is visible');
					gotoFeel();
					
					//stop();
					setTimeout(function() {
						next();
					},100);
				},
				function(next){
					//start();
					var $btnSave = $("#btn-save"),
						$tbFeelPh = $('#feelings-physically'),
						$tbFeelMe = $('#feelings-mentally'),
						$tbFeelDd = $('#feelings-day-to-day');

					ok($tbFeelPh.is(":visible"),
						'I can see feelings-physically text box');
					ok($tbFeelMe.is(":visible"),
						'I can see feelings-mentally text box');
					ok($tbFeelDd.is(":visible"),
						'I can see feelings-day-to-day text box');

					ok($btnSave.is(":visible"),
							"Save Button is visible");
					//Changes
					$tbFeelPh.val('2').trigger('change');
					$tbFeelMe.val('10').trigger('change');
					$tbFeelDd.val('0').trigger('change');

					$btnSave.trigger('tap');
					//stop();
					setTimeout(function(){
						next();
					},100);

				},
				function(next){
					gotoFeel();
					setTimeout(function(){
						next();
					},100);
				},
				function(next){
					var $tbFeelPh = $('#feelings-physically'),
						$tbFeelMe = $('#feelings-mentally'),
						$tbFeelDd = $('#feelings-day-to-day');
					equal($tbFeelPh.val(), '2' , 'Feelings value for phisically should be 2');
					equal($tbFeelMe.val(), '10' , 'Feelings value for Mentally should be 10');
					equal($tbFeelDd.val(), '1' , 'Feelings value for "Day to day" should be 1');
					start();
					
				}
			]);
		});

	};
	return {
		initialize: defineTests
	};
});
