define([
	'jQuery'
], function($$) {
	var defineTests = function() {
		function gotoDesire(){
			$('a:contains("What I Want")').simulate('click');
		}
		module("#97 MyGoals Inventory/Learn - current and desired state");
		
		asyncTest("Navigate to the 'What I Want' section of the app", function(){
			ok($('a:contains("What I Want")').is(':visible'), '"What I want" button is visible');
			gotoDesire();

			setTimeout( function(){

				equal($('.ui-title').text().trim(),
					'What I Want',
					'What I Want page loaded');
				var links = $('a[href^=#desire]');
			
				var handleSingleDesire = function(index, links){

					var $link = $(links[index]),
						question = $link.find('h3').text().trim();

					if(index < 0){
						start();
						return ;
					}
					else
					{
						//go to page
						window.frames[0].location.hash = '#desire/'+(index+1);

						setTimeout(function(){
						
							var $quote = $('#form-question > q'),
								heading = $('header h3').text().trim(),
								$learnInfo = $('#form-question > span');
							if ($quote.length > 0 )
							{
								ok($quote.text().trim().length > 0,
									'Contains a quote and is not empty.');
							}
							ok($learnInfo.is(':visible'),
								question+': Information on each component of self-care is available');
							ok($learnInfo.text().trim().length > 0,
								question+': Learn information contains content');
							equal(question, heading, question+': heading is correct');

//							handleSingleDesire( index -1 , links);
							start();
						}, 100);
					}
				};
				handleSingleDesire( links.length -1 , links );
			},100);
		});
	};
	return {
		initialize: defineTests
	};
});
