define([
	'jQuery',
	'async',
	'../helpers'
], function($$, async, helpers ) {
	var defineTests = function() {
		//$$.noConflict(true);
		var myFrame = $$("#myFrame"),
			appName = 'MyStory';
		module("#398 MyGoals: Health Inventory app-specfic Authentication");

		asyncTest("#404 App-specific Home button prompts the user about saving", function(){
			expect(2);
			async.series([
				function(next){
					var $link = $('a h3:contains("How I Feel")');
					ok( $link.is(':visible'), 'How I feel is visible');
					$link.simulate('click');
					//stop();
					setTimeout(function(){
						next(null);
					}, 100 );
				},
				function(next){
					$('#feelings-physically').val(2).trigger('change');
					$('#footer').find('a[href="#home"]').trigger('tap');
					setTimeout(function(){
						next(null);
					}, 100 );
				},
				function(next){
					ok( $('#confirmBox:contains("Exit Confirmation")').is(':visible'),
					'Home button should prompt the user to save.' );
					start();
				}]);
		});
		test("#405 and #402 App-specific logout buttons prompts the user about saving",3, function(){
			
			async.series([
				function(next){
					//start();
					var $link = $('a h3:contains("How I Feel")');
					ok( $link.is(':visible'), 'How I feel is visible');
					$link.simulate('click');
					//stop();
					//start();
					stop(4000);
					setTimeout(function(){
						next(null);
					}, 100 );
				},
				function(next){
					//start();
					$('#feelings-physically').val(2).trigger('change');
					//$('a:contains("Logout")').simulate('click');
					$('#footer')
						.find('a:contains("Logout")' )
						.trigger('tap');
					ok( $('#confirmBox:contains("Exit Confirmation")').is(':visible'),
						'Logout button should prompt the user to save.' );
					$('#confirmOverlay')
						.find('a:contains("Exit [No Save]")')
						.simulate('click');
					setTimeout(function(){
						next(null);
					}, 1000 );
				},
				function(next){
					equal($('h3.ui-title:contains('+appName+')').text().trim(),
					appName,
					'Logout redirects to the Home when selected');
					//stop();
					//stop();

					start(4000);
					
						next(null);
				}
			]);
		});


	};
	return {
		initialize: defineTests
	};
});
