define([
	'jQuery',
	'../helpers'
], function($$, helpers) {
	var defineTests = function() {
		function gotoLearn(){
			$('a:contains("Learn")').simulate('click');
		}
		module("#335 MyGoals Learn ");
		
		asyncTest("Navigate to the Learn section of the app", function(){
			expect(2);
			ok($('a h3:contains("Learn")').is(':visible'), 'Learn button is visible');
			gotoLearn();
			setTimeout( function(){
				ok($('h3:contains("Learn")').is(':visible'), 'Learn page loaded with title');
				start();
			},100);

		});
		asyncTest('Check sections are available and visible', function() {
			expect(21);
			async.series([
				function(next){
					ok($('a:contains("Learn")').is(':visible'), 'Summary button is visible');
					gotoLearn();
					
					setTimeout(function() {
						next();
					}, 100);
				},
				function(next){
					
					ok($('h3:contains("Learn")').is(':visible'), 'Learn page loaded with title');
					//components
					ok($('.components.graphic').is(':visible'),
						'the components title is available');
					equal($('.slider .components.graphic').attr('title').trim(),
						'The Components of Proactive Health and Well Being',
							"components title is correct");
					//me
					ok($('.slider .me.graphic').is(':visible'),
						'the me title is available');
					equal($('.slider .me.graphic').attr('title').trim(), 'Me',
							"Me title is correct");
					//mindfulAwareness
					
					setTimeout(function() {
						next();
					}, 100);
				},
				function(next){
					
					ok($('.slider .mindful-awareness.graphic').is(':visible'),
						'the mindful Awareness title is available');
					equal($('.slider .mindful-awareness.graphic').attr('title').trim(), 'Mindful Awareness',
							"mindful Awareness title is correct");
					//selfCare
					ok($('.slider .self-care.graphic').is(':visible'),
						'the selfCare title is available');
					equal($('.slider .self-care.graphic').attr('title').trim(), 'Self Care',
							"selfCare title is correct");
					//professionalCare
					ok($('.slider .professional-care.graphic').is(':visible'),
						'the professionalCare title is available');
					equal($('.slider .professional-care.graphic').attr('title').trim(), 'Professional Care',
							"professionalCare title is correct");
					//community
					ok($('.slider .community.graphic').is(':visible'),
						'the Community title is available');
					equal($('.slider .community.graphic').attr('title').trim(), 'Community',
							"comunity title is correct");

				
					setTimeout(function() {
						next();
					}, 100);
				},
				function( next ){
				
					//Self Care Areas
					ok($('.slider div[data-role="collapsible-set"] h3:contains("Working Your Body")').is(':visible'),
						'the selfCare title is available');
					ok($('.slider div[data-role="collapsible-set"] h3:contains("Surroundings")').is(':visible'),
						'the selfCare title is available');
					ok($('.slider div[data-role="collapsible-set"] h3:contains("Personal Development")').is(':visible'),
						'the selfCare title is available');
					ok($('.slider div[data-role="collapsible-set"] h3:contains("Food & Drink")').is(':visible'),
						'the selfCare title is available');
					ok($('.slider div[data-role="collapsible-set"] h3:contains("Recharge")').is(':visible'),
						'the selfCare title is available');
					ok($('.slider div[data-role="collapsible-set"] h3:contains("pirit & Soul")').is(':visible'),
						'the selfCare title is available');
					ok($('.slider div[data-role="collapsible-set"] h3:contains("Power of the Mind")').is(':visible'),
						'the selfCare title is available');
					setTimeout(function() {
						start();
					}, 100);
				}]);
			
		});

	};
	return {
		initialize: defineTests
	};
});
