define([
	'jQuery',
	'async'
], function($$, async ) {
	var defineTests = function() {
		function newPriority() {
			if ($('#btn-yes').is(':visible')){
				ok($('#btn-yes').trigger('tap'),"Clicked n yes");
				}
		}
		module("ms-277-Ability to enter Priority 1&2");
		
		asyncTest("Validate the ability to enter Priority 1&2", function(){
			async.series([
				function(next){
					ok($('h3:contains("MyStory")').is(':visible'), '"MyStory" page is visible');
					$('[href="#priorities"]')[0].click();
					setTimeout(function() {
						next();
					}, 100);
				},
				function(next){
					ok($('.ui-title').text().trim(),
						'My Priorities',
						'My Priorities page loaded');
					setTimeout(function() {
						next();
					}, 100);
				},
				function(next){
					newPriority();
					setTimeout(function() {
						next();
					}, 100);
				},
				function(next){
					//Go back to What I Want section is displayed
					//ok($('h1:contains("Set Priorities")').is(':visible'), '"Set Priorities" page is visible');
					ok($('#priority1-area').is(':enabled'), 'Priority 1 is enabled');
					
					
					//Validate the drop down options under priority 1
					equal($("#priority1-area :contains('Working My Body')").length>0,
							true, 'Option 1');
					equal($("#priority1-area :contains('My Surroundings')").length>0,
							true, 'Option 2');
					equal($("#priority1-area :contains('My Personal Development')").length>0,
							true, 'Option 3');
					equal($("#priority1-area :contains('My Food and Drink')").length>0,
							true, 'Option 4');
					equal($("#priority1-area :contains('My Relationships')").length>0,
							true, 'Option 5');
					equal($("#priority1-area :contains('Spirit and Soul')").length>0,
							true, 'Option 6');
					equal($("#priority1-area :contains('Power of the Mind')").length>0,
							true, 'Option 7');
					equal($("#priority1-area :contains('My Health Care')").length>0,
							true, 'Option 8');
					
					//Select an option from the Priority1 drop down
					$('#priority1-area').val('My Surroundings').selectmenu('refresh').trigger('change');
					ok($('#priority1-goal').is(':visible'),'Goal drop down is visible');
					//Validate the goal options in the drop down
					equal($("#priority1-goal :contains('Create a relaxing space')").length>0,
							true, 'Goal 1');
					equal($("#priority1-goal :contains('Clean up clutter')").length>0,
							true, 'Goal 2');
					equal($("#priority1-goal :contains('Talk to my VA Team')").length>0,
							true, 'Goal 3');
					equal($("#priority1-goal :contains('Enter My Own')").length>0,
							true, 'Goal 4');
					//Select a goal from the drop down
					$('#priority1-goal').val('Clean up clutter').selectmenu('refresh');
					//Save Priority1
					$('#btn-save').trigger('tap');
					setTimeout(function() {
						next(null);
					}, 100);
					
					//Go to Food and Drink sub-section
					ok($('#priority2-area').is(':enabled'), 'Priority 2 is enabled');
					setTimeout(function() {
						next();
					}, 100);
				next(null);
					start();
				}
			]);
			
		});
	};
	return {
		initialize: defineTests
	};
});
