define([
	'jQuery',
	'async'
], function($$, async ) {
	var defineTests = function() {
		function gotoReflections(){
			$('a:contains("Reflections")').simulate('click');
		}
		module("#101 MyGoals Inventory/Reflections");
		
		asyncTest("Navigate to the 'Reflections' section of the app", function(){
			expect(8);
			var $links = null,
				$link = null,
				expectedDateUpdated = '',
				question = '',
				answer = '';

			async.series([
				function(next){
					ok($('h3:contains("MyStory")').is(':visible'), '"MyStory" page is visible');
					gotoReflections();
					setTimeout(function() {
						next();
					}, 100);
				},
				function(next){
					$links = $('.ui-li a').clone();
			
					equal($('.ui-title').text().trim(),
						'Reflections',
						'Reflections page loaded');

					$link = $links.first();
					$links = $links.slice(1);
					$link.simulate('click');

					setTimeout(function() {
						next(null);
					}, 100);
				},
				function(next){
					//Disclaimer is displayed - Defect MS-270
					ok($('p:contains("If you require immediate care, please call 911 or contact the VA Crisis Hotline at 1-800-273-8255")')
							.is(':visible'),'Disclaimer is visible');
					//where: reflection detail
					var now = new Date(),
						$textarea = $('textarea'),
						$btnSave = $('#btn-save');
					question = $link.find('h3').text();
					answer = 'this is a test with id' + question;
					expectedDateUpdated = '' + (now.getMonth()+1) + "/" + now.getDate() + "/" + now.getFullYear();

					ok($textarea.is(':visible'), question + ': textarea is visible');
					ok($btnSave.is(':visible'), question + ': save button is visible');
					$textarea.text(answer);
					$btnSave.trigger('tap');
					setTimeout(function() {
						next(null);
					}, 100);
				},
				function(next){
					$link = $('a[href="' + $link.attr('href') + '"]');
					var actualDateUpdated = $link.find('.last-updated').text();

					equal( actualDateUpdated,
							expectedDateUpdated,
							question + ": update date is correctly updated");
					
					$link.simulate('click');
					setTimeout(function() {
						next(null);
					}, 100);

				},
				function(next){
					//where: reflection detail
					var title_text = $('.ui-title').text().trim();
					equal( $('textarea').text(),
						answer,
						question + ": verified did save.");
					equal( question, title_text, question + ': link text matches question title');
					//if ($links.length) {
						//gotoReflections();
						//checkeach();
					//} 
					next(null);
					start();
				}
			]);
			
		});
	};
	return {
		initialize: defineTests
	};
});
