define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#39949 Vital Signs Graph");
		
		function clickFooter()
		{
			$('#footer-more-btn').trigger('tap'); 
			$('#footer-vital-signs-btn').trigger('tap');
			
			return 500;
		}


		test('Verify vitals available to be graphed', function() {

			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				var vitals = $('#graph-results a h3');
				equal(vitals.eq(0).text() ,'BP', 'Verify BP vital');
				equal(vitals.eq(1).text() ,'Pulse', 'Verify Pulse vital');
				equal(vitals.eq(2).text() ,'Respiration', 'Verify Respiration vital');
				equal(vitals.eq(3).text() ,'Temperature', 'Verify Temperature vital');
				equal(vitals.eq(4).text() ,'Weight', 'Verify Weight vital');
				equal(vitals.eq(5).text() ,'Pain', 'Verify Pain vital');
				equal(vitals.eq(6).text() ,'Pulse Ox', 'Verify Pulse Ox vital');
			});
		});
		
		test('Verify that vitals have visual indicator when clicked', function() {

			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				var vitalLength = $('#graph-results li').length;
				
				for(var i=1; i <= vitalLength; i++)
				{
					$('#graph-results li:nth-child('+ i +') a').trigger('tap');
					ok($('#graph-results li:nth-child('+ i +').ui-btn-active'), 'Selected vital is active');
				}
			});
		});
		
		test('Verify the date range options', function() {

			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				$('#graph-results a').eq(0).trigger('tap');
			}, function() {
				if(window.location.href.indexOf('patient-viewer') > 1)
				{
					equal($('#date-range-selection li:nth-child(1) a').text(), '1 Week',
						'Verify the 1 Week filter');
					equal($('#date-range-selection li:nth-child(2) a').text(), '1 Month',
							'Verify the 1 Month filter');
					equal($('#date-range-selection li:nth-child(3) a').text(), '1 Year',
							'Verify the 1 year filter');
					equal($('#date-range-selection li:nth-child(4) a').text(), '2 Years',
							'Verify the 2 Years filter');
					equal($('#date-range-selection li:nth-child(5) a').text(), 'Custom Range',
							'Verify the Custom Range filter');
				}
				else
				{
					equal($('#date-range-selection li:nth-child(1) a').text(), '1 Month',
						'Verify the 1 Month filter');
					equal($('#date-range-selection li:nth-child(2) a').text(), '6 Months',
							'Verify the 6 Months filter');
					equal($('#date-range-selection li:nth-child(3) a').text(), '1 Year',
							'Verify the 1 year filter');
					equal($('#date-range-selection li:nth-child(4) a').text(), '2 Years',
							'Verify the 2 Years filter');
					equal($('#date-range-selection li:nth-child(5) a').text(), 'Custom Range',
							'Verify the Custom Range filter');
				}
			});
		});
		
		test('Verify the name of the vital is displayed above the graph', function() {
			var vitals;
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				vitals = $('#graph-results a h3');
				ok(vitals, 'Vitals list is not empty');
				vitals.eq(0).trigger('tap');
			}, function() {
				equal($('legend').text(),'Blood Pressure', 'Verify BP vital');
				vitals.eq(1).trigger('tap');
				equal($('legend').text() ,'Pulse', 'Verify Pulse vital');
				vitals.eq(2).trigger('tap');
				equal($('legend').text() ,'Respiration', 'Verify Respiration vital');
				vitals.eq(3).trigger('tap');
				equal($('legend').text() ,'Temperature', 'Verify Temperature vital');
				vitals.eq(4).trigger('tap');
				equal($('legend').text() ,'Weight', 'Verify Weight vital');
				vitals.eq(5).trigger('tap');
				equal($('legend').text() ,'Pain', 'Verify Pain vital');
				vitals.eq(6).trigger('tap');
				equal($('legend').text() ,'Pulse Oximetry', 'Verify Pulse Ox vital');
			});
		});

		test('Verify the custom date range of the graph', function() {

			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				var vitals = $('#graph-results a h3');
				vitals.eq(1).trigger('tap');
			}, function() {
				$('#date-range-selection li:nth-child(5) a').trigger('tap');
				
				$('form [name=startDate]').val('10/10/2009').trigger('change');
				$('form [name=endDate]').val('01/01/2013').trigger('change');
				$('#add-custom-date').trigger('tap');
				var lastX = $('.highcharts-axis-labels').eq(0).find('tspan').length -1;
				var lastY = $('.highcharts-axis-labels').eq(1).find('tspan').length -1;
				var xAxisFirst = $('.highcharts-axis-labels').eq(0).find('tspan').eq(0).text();
				var xAxisLast = $('.highcharts-axis-labels').eq(0).find('tspan').eq(lastX).text();
				var yAxisFirst = $('.highcharts-axis-labels').eq(1).find('tspan').eq(1).text();
				var yAxisLast = $('.highcharts-axis-labels').eq(1).find('tspan').eq(lastY).text();

				equal(xAxisFirst, "Jan '11", 'Verify the first entry on the X axis');
				equal(xAxisLast, "Jul '12", 'Verify the last entry on the X axis');
				equal(yAxisFirst, "60.0", 'Verify the first entry on the Y axis');
				equal(yAxisLast, "110.0", 'Verify the last entry on the Y axis');
			});
		});

		test('Verify the 1 and 6 month graph range when no data exists', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#graph-results a h3').eq(0).trigger('tap');
			}, function() {
				var oneMonth = $('#date-range-selection li:nth-child(1) a');
				var sixMonth = $('#date-range-selection li:nth-child(2) a');
				
				oneMonth.trigger('tap');
				var graphData = $('#graph-area p').text();
				equal(graphData, "No Data Found Within the Specified Date Range", 'Verify the message when no vitals are within range');

				sixMonth.trigger('tap');
				graphData = $('#graph-area p').text();
				equal(graphData, "No Data Found Within the Specified Date Range", 'Verify the message when no vitals are within range');
			});
				
		});
		
		test('Verify the graph defaults to a 2-year range', function() {

			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				var vitals = $('#graph-results a h3');
				vitals.eq(0).trigger('tap');

				equal($('#date-range-selection li:nth-child(4) .ui-btn-active').length,
						'1', 'Verify that the 2-year button is active');
			});
		});
		
		test('Verify that dates over 6 years cannot be selected for custom durations', function(){
			
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#graph-results a h3').eq(0).trigger('tap');
			}, function() {
				$('#date-range-selection .ui-block-e a').trigger('tap');
				$('form [name=startDate]').val('10/10/2006').trigger('change');
				$('form [name=endDate]').val('11/10/2012').trigger('change');
				$('#date-from').datebox('open');
				equal($('.ui-datebox-griddate-disable').length, 31, 'Verify that all days over 6 years are disabled');
				$('.ui-datebox-container a').trigger('click');
				$('#date-from').datebox('open');
				$('form [name=startDate]').val('11/10/2006').trigger('change');
				equal($('.ui-datebox-griddate-disable').length, 0, 'Verify that all days within 6 years are enabled');
				$('#custom-date-menu a').trigger('click');
			});
		});

//The following tests are too unreliable to automate because the x-axis labels are not controlled		
//		asyncTest('Verify the 1-year graph range', function() {
//			clickFooter();
//				setTimeout(function() {
//					start();
//
//					var vitals = $('#graph-results a h3');
//					vitals.eq(0).trigger('tap');
//					stop();
//					setTimeout(function() {
//						start();
//					}, 1000);
//					var xAxisFirst = $('.highcharts-axis-labels').eq(0).find('tspan').eq(0).text();
//					var xAxisLast = $('.highcharts-axis-labels').eq(0).find('tspan').eq(5).text();
//					var yAxisFirst = $('.highcharts-axis-labels').eq(1).find('tspan').eq(1).text();
//					var yAxisLast = $('.highcharts-axis-labels').eq(1).find('tspan').eq(7).text();
//
//					equal(xAxisFirst, "May '10", 'Verify the first entry on the X axis');
//					equal(xAxisLast, "Jan '12", 'Verify the last entry on the X axis');
//					equal(yAxisFirst, "65", 'Verify the first entry on the Y axis');
//					equal(yAxisLast, "95", 'Verify the last entry on the Y axis');
//
//				}, 100);
//				
//		});
//		The following tests are too unreliable to automate because the x-axis labels are not controlled
//		asyncTest('Verify the labels for the x and y axes for a 2-year range', function() {
//			clickFooter();
//				setTimeout(function() {
//					start();
//
//					var vitals = $('#graph-results a h3');
//					vitals.eq(0).trigger('tap');
//					stop();
//					var xAxisFirst = $('.highcharts-axis-labels').eq(0).find('tspan').eq(0).text();
//					var xAxisLast = $('.highcharts-axis-labels').eq(0).find('tspan').eq(5).text();
//					var yAxisFirst = $('.highcharts-axis-labels').eq(1).find('tspan').eq(1).text();
//					var yAxisLast = $('.highcharts-axis-labels').eq(1).find('tspan').eq(7).text();
//
//					equal(xAxisFirst, "Mar '11", 'Verify the first entry on the X axis');
//					equal(xAxisLast, "Mar '12", 'Verify the last entry on the X axis');
//					equal(yAxisFirst, "65", 'Verify the first entry on the Y axis');
//					equal(yAxisLast, "95", 'Verify the last entry on the Y axis');
//					setTimeout(function() {
//						start();
//					}, 1000);
//				}, 100);
//				
//		});
		
	};
	
	return {
		initialize: defineTests
	};
});
