define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#39630 Convert SoC to jQM/Backbone");

		function getAge(year, month, day) {
			var today = new Date();
			var birthDate = new Date(year, month, day);
			var age = today.getFullYear() - birthDate.getFullYear();
			var m = today.getMonth() - birthDate.getMonth();
			if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
				age--;
			}
			return age;
		}
		
		function searchInpatient()
		{
			//This method is used by patient viewer to search and select a patient before proceeding
			if(window.location.href.indexOf('patient-viewer') > 1)
			{
				$('#patient-search input').val("patient60").trigger('change');
				$('#patient-search-results li:nth-child(2) a').trigger('tap');
			}
		}

		//Section title validation
		test('Display Demographic data', function() {
			searchAndSelectPatient();
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var demographicsBtn = $('#section-list li:nth-child(1) a');
				var sectionHeading = $('#summary-Contact-Information h3').text().trim();
				equal(sectionHeading, 'patient66, zztest', 'Verify the heading of the Demographics section');
			});
		});
		
		test('Display Medical Diagnoses', function() {
			searchAndSelectPatient();
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var diagnosesBtn = $('#section-list li:nth-child(2) a');	
				var sectionHeading = $('#summary-Medical-Diagnoses h2').text().trim();
				equal(sectionHeading, 'Medical Diagnoses', 'Verify the heading of the Medical Diagnoses section');
			});
		});
		
		test('Display Medical Diagnoses again', function() {
			searchAndSelectPatient();
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var diagnosesBtn = $('#section-list li:nth-child(2) a');	
				var sectionHeading = $('#summary-Medical-Diagnoses h2').text().trim();
				equal(sectionHeading, 'Medical Diagnoses', 'Verify the heading of the Medical Diagnoses section');
			});
		});
		
		test('Display Allergies', function() {
			searchAndSelectPatient();
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var allergiesBtn = $('#section-list li:nth-child(3) a');	
				var sectionHeading = $('#summary-Allergies h2').text().trim();
				equal(sectionHeading, 'Allergies', 'Verify the heading of the Allergies section');
			});
		});

		test('Display Medications', function() {
			searchAndSelectPatient();
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var medicationsBtn = $('#section-list li:nth-child(4) a');	
				var sectionHeading = $('#summary-Outpatient-Medications h2').text().trim();
				equal(sectionHeading, 'OUTPATIENT Medications', 'Verify the heading of the Medications section');
			});
		});
		
		test('Display Surgeries', function() {
			searchAndSelectPatient();
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var surgeries = $('#section-list li:nth-child(5) a');	
				var sectionHeading = $('#summary-Surgeries h2').text().trim();
				equal(sectionHeading, 'Surgeries', 'Verify the heading of the Surgeries section');
			});
		});
		
		//Contact Information Content Validation
		test('Verify that the gender is spelled out', function() {
			searchAndSelectPatient();
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				equal($('#summary-Contact-Information [name="gender"]').text(), 'MALE', 'Verify that the gendder is spelled out');
			});
		});

		test('Verify the format of the DOB and age calculation', function() {
			searchAndSelectPatient();
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var dob = 'Jan 01, 1900';
				var age = getAge(1900, 0, 1);
				equal($('#summary-Contact-Information [name="dob"]').text(), dob + ' (' + age + ')', 'Verify the format of DOB and calculated age');
			});
		});
		
		test('Verify all fields in the contact info section', function() {
			searchAndSelectPatient();
			expect(10);
			asyncSeries(function() {
				return 200;
			}, function() {
				var name = $('#summary-Contact-Information h3').text().trim();
				var dob = $('#summary-Contact-Information [for="dob"]').text().trim();
				var gender = $('#summary-Contact-Information [for="gender"]').text().trim();
				var officePhone = $('#summary-Contact-Information [for="number-work"]').text().trim();
				var homePhone = $('#summary-Contact-Information [for="number-home"]').text().trim();
				var cell = $('#summary-Contact-Information [for="number-mobile"]').text().trim();
				var pager = $('#summary-Contact-Information [for="number-pager"]').text().trim();
				var email = $('#summary-Contact-Information [for="email"]').text().trim();
				var location = $('#summary-Contact-Information [for="location"]').text().trim();
				var address = $('#summary-Contact-Information [for="address1"]').text().trim();
					
				equal(name, "patient66, zztest", 'Verify that the name is displayed');
				equal(dob, "Date of Birth", 'Verify that the label Date of Birth is displayed');
				equal(gender, "Gender", 'Verify that the label gender is displayed');
				equal(officePhone, "Work", 'Verify that the label work phone is displayed');
				equal(homePhone, "Home", 'Verify that the label home phone is displayed');
				equal(cell, "Cell", 'Verify that the label cell phone is displayed');
				equal(pager, "Pager", 'Verify that the label pager is displayed');
				equal(email, "Email", 'Verify that the label for email is displayed');
				equal(location, "Location", 'Verify that the label for location is displayed');
				equal(address, "Address", 'Verify that the label for address is displayed');
			});
			
		});
		
		test('Verify the phone number fields when the data is populated', function() {
			searchAndSelectPatient();
			expect(3);
			asyncSeries(function() {
				return 200;
			}, function() {
				var phone = $('#summary-Contact-Information [name="number-work"]').text().trim();
				equal(phone, "(111)111-1111", 'Verify No Data Found is displayed when the person has no work phone number');
				phone = $('#summary-Contact-Information [name="number-home"]').text().trim();
				equal(phone, "(000)000-0000", 'Verify No Data Found is displayed when the person has no home phone number');
				phone = $('#summary-Contact-Information [name="number-mobile"]').text().trim();
				equal(phone, "(222)222-2222", 'Verify No Data Found is displayed when the person has no mobile phone number');
			});
		});
		
		test('Verify the content of the address fields', function() {
			searchAndSelectPatient();
			expect(4);
			asyncSeries(function() {
				return 200;
			}, function() {
				var addr = $('#summary-Contact-Information [name="address1"]').text().trim();
				equal(addr, "0 Street Address", 'Verify that valid address data is displayed on line 1 of the address');
				addr = $('#summary-Contact-Information [name="address2"]').text().trim();
				equal(addr, "Suite 500", 'Verify that valid address data is displayed on line 2 of the address');
				addr = $('#summary-Contact-Information [name="address3"]').text().trim();
				equal(addr, "Box 1234", 'Verify No Data Found is displayed when the person has no address line 3 data');
				addr = $('#summary-Contact-Information [name="address4"]').text().replace(/\s/g, '');
				equal(addr, "Mock,CA20151-4657", 'Verify No Data Found is displayed when the person has no address line 4 data');
			});
		});
		
		
		test('Verify the email field behaves correctly when no data is found', function() {
			searchAndSelectPatient();
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var email = $('#summary-Contact-Information [name="email"]').text().trim();
				equal(email, "No Data Found", 'Verify No Data Found is displayed when the person has no email');
			});
		});
		
		test('Verify the location when the person is not admitted', function() {
			searchAndSelectPatient();
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var location = $('#summary-Contact-Information [name="location"]').text().trim();
				equal(location, "Not Currently Admitted", 'Verify the location is Not Currently Admitted');
			});
		});
		
		test('Verify the support number to change contact info', function() {
			searchAndSelectPatient();
			expect(1);
			asyncSeries(function() {
				return 200;
			}, function() {
				var support = $('#summary-Contact-Information [name="support"]').text().trim();
				equal(support, "To update your demographic data, contact the Health Eligibility Center: 1-800-929-8387", 'Verify the message to update contact info');
			});
		});

		test('Verify the Next of Kin section', function() {
			searchAndSelectPatient();
			expect(4);
			asyncSeries(function() {
				return 200;
			}, function() {
				var nokHeader = $('#summary-Contact-Information h4').text();
				var kinRelationship = $('#summary-Contact-Information [for="relationship"]').text();
				var kinName = $('#summary-Contact-Information [for="kin-name"]').text();
				var kinPhone = $('#summary-Contact-Information [for="kin-phone"]').text();
				
				equal(nokHeader, "Next Of Kin", 'Verify the header for the Next of Kin section');
				equal(kinRelationship, "Relationship", 'Verify Relationship field exists');
				equal(kinName, "Name", 'Verify the Name field exists');
				equal(kinPhone, "Home", 'Verify the home phone field exists');
			});
		});
		
		//Medical Diagnoses Validation
		test('Verify column headers for Medical Diagnoses', function() {
			searchAndSelectPatient();
			expect(3);
			asyncSeries(function() {
				return 200;
			}, function() {
				equal($('#summary-Medical-Diagnoses-table th:eq(0)').text(), "Current", 'Verify the first column header');
				equal($('#summary-Medical-Diagnoses-table th:eq(1)').text(), "Date", 'Verify the second column header');
				equal($('#summary-Medical-Diagnoses-table th:eq(2)').text(), "Source", 'Verify the third column header');
			});
		});
		
		//Allergies Validations
		test('Verify column headers for Allergies', function() {
			searchAndSelectPatient();
			expect(3);
			asyncSeries(function() {
				return 200;
			}, function() {
				equal($('#summary-Allergies th:eq(0)').text(), "Allergen", 'Verify the first column header');
				equal($('#summary-Allergies th:eq(1)').text(), "Reaction", 'Verify the second column header');
				equal($('#summary-Allergies th:eq(2)').text(), "Source", 'Verify the third column header');
			});
		});
		
		
		//Surgeries Validation
		test('Verify column headers for Surgeries', function() {
			searchAndSelectPatient();
			expect(3);
			asyncSeries(function() {
				return 200;
			}, function() {
				equal($('#summary-Surgeries th:eq(0)').text(), "Description", 'Verify the first column header');
				equal($('#summary-Surgeries th:eq(1)').text(), "Date", 'Verify the second column header');
				equal($('#summary-Surgeries th:eq(2)').text(), "Facility", 'Verify the third column header');
			});
		});
		
		//Medications Validation
		test('Verify the columns for the Medications section', function() {
			searchAndSelectPatient();
			expect(3);
			asyncSeries(function() {
				return 200;
			}, function() {
				equal($('#outpatientMeds th:nth-child(1)').text().trim(),
						"Active and Recently Expired", 'Verify the Active and Recently Expired header');
				equal($('#outpatientMeds th:nth-child(2)').text().trim(),
						"Status", 'Verify the Status header');
				equal($('#outpatientMeds th:nth-child(3)').text().trim(),
						"Source", 'Verify the Source Expired header');
			});
		});
	
	};
	
	return {
		initialize: defineTests
	};
});
