define([
	'jQuery',
	'async',
	'asyncSeries',
	'testUtilities'
], function($$, async, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#37353 Vital Signs Table View");
		
		function clickTable () 
		{
			var tableButton = $('#vital-signs-list div:nth-child(1) li a');
			tableButton.trigger('tap');
		}
		
		function clickFooter()
		{
			$('#footer-more-btn').trigger('tap'); 
			$('#footer-vital-signs-btn').trigger('tap');
		}
		
		test('Verify table header elements for vitals', function() {
			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				clickTable();
				return 500;
			}, function() {
				var tableHeaders = $('#vital-sign-table th');
				equal(tableHeaders.eq(1).text(), 'BP', 'Verify the BP header');
				equal(tableHeaders.eq(2).text(), 'Weight', 'Verify the BP header');
				equal(tableHeaders.eq(3).text(), 'Temp', 'Verify the BP header');
				equal(tableHeaders.eq(4).text(), 'Pulse', 'Verify the BP header');
				equal(tableHeaders.eq(5).text(), 'Respirations', 'Verify the BP header');
				equal(tableHeaders.eq(6).text(), 'Pain', 'Verify the BP header');
				equal(tableHeaders.eq(7).text(), 'Pulse Ox', 'Verify the Oxygen header');
			});
		});

		
		test('Past vital signs are sorted in reverse chronological order', function() {
			
			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				clickTable();
				return 500;
			}, function() {
				var vitalsLength = $('#vital-sign-table tr').length;
				ok(vitalsLength > 0, 'Patient has at least one vital signs result');
					
				var previousDate = new Date($('#vital-sign-table tr:nth-child(1) td:nth-child(1)').text().trim());
				for (var i = 1; i < vitalsLength; i ++) {
					var vitalsDate = new Date($('#vital-sign-table tr:nth-child('+ i +') td:nth-child(1)').text().trim()); 
						
					ok(previousDate >= vitalsDate, 'Previous date is greater than or equal to current date (reverse chronological order)');
					previousDate = vitalsDate;
				}
			});
		});
		
		test('Verify that dates are only displayed if there is a test result on that day', function() {

			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				clickTable();
			}, function() {
				equal($('#vital-sign-table td:contains("12/15/2011")').text().trim(),
						'12/15/2011',
						'Verify that the table contains 12/15/2011');
				equal($('#vital-sign-table td:contains("12/14/2011")').text().trim(),
						'',
						'Verify that the table does not contain 12/14/2011 because there is no data for that day');
				equal($('#vital-sign-table td:contains("12/13/2011")').text().trim(),
						'12/13/2011',
						'Verify that the table contains 12/13/2011');
			});
		});
		
		test('Verify that only the latest lab result from the same day is displayed', function() {

			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				clickTable();
			}, function() {
				var date = $('#vital-sign-table tr:nth-child(6) td:nth-child(1)').text().trim();
				var bp = $('#vital-sign-table tr:nth-child(6) td:nth-child(2)').text().trim();

				equal(date, '01/16/2012', 'Verify the date that has multiple results in the same day');
				equal(bp, '135/86', 'Verify only the latest value is displayed within the same day');
			});
		});
		
	};
	
	return {
		initialize: defineTests
	};
});
