define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#37175: Lab Viewer");

		function clickFooter()
		{
			$('#footer-lab-results-btn').trigger('tap');
			$('#footer-more-btn').trigger('tap');
			$('#footer-lab-results-btn').trigger('tap');
			return 500;
		}
		
		test('Verify the navigation and lab headings', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				if(window.location.href.indexOf('patient-viewer') > 1)
				{
					equal($('#tabView li:nth-child(1) .ui-btn-text').text(), 
							'Chem / Hem', 
							'Verify the label for labs that can be graphed');
					equal($('#tabView li:nth-child(2) .ui-btn-text').text(), 
							'Microbiology', 
							'Verify the label for sorting by time');
				}
				else
				{
					equal($('#tabView li:nth-child(1) .ui-btn-text').text(), 
							'Graph', 
							'Verify the label for labs that can be graphed');
					equal($('#tabView li:nth-child(2) .ui-btn-text').text(), 
							'Time', 
							'Verify the label for sorting by time');
				}
			});
		});

		
		test('Verify the contents of a lab result button', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				equal($('#lab-list div:nth-child(1) li:nth-child(2) a h3').text(), 
						'RBC (BLOOD)', 
						'Verify that WBC appears first in the list');
				equal($('#lab-list div:nth-child(1) li:nth-child(2) a p').text(), 
						'05/23/2011', 
						'Verifyy that the date is listed');
				equal($('#lab-list div:nth-child(1) li:nth-child(2) h4').text(), 
						'Red Blood Cells', 
						'Verify that the full lab name is displayed');
				equal($('#lab-list div:nth-child(1) li:nth-child(2) a span').text(), 
						'3.95', 
						'Verify that the value of the lab result is listed');
			});
		});
		
		
		test('Verify that no lab name is displayed if the full name is not in the CDW', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				ok($('#lab-list div:nth-child(1) li:nth-child(1) h3'),
				'Verify the abbreviated lab name is populated');
				equal($('#lab-list div:nth-child(1) li:nth-child(1) h4').text(),
				'',
				'Verify the full lab name is an empty string');
			});
		});
		

	};
	
	
	return {
		initialize: defineTests
	};
});
