define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#36961 Medication View");

		function clickFooter()
		{
			$('#footer-more-btn').trigger('tap'); 
			$('#footer-medications-btn').trigger('tap');
			
			return 500;
		}
		
		function getMedListCount()
		{
			return $('#medications-list li').length;
		}
		
		function getMedName(iteration)
		{
			return $('#medications-list li:nth-child(' + iteration + ') h3').text().toLowerCase();
		}
		
		function expandDateRange()
		{
			$('#filter-range-btn').trigger('tap');
			$('#filter-date-from').val('01/01/2008').trigger('change');
			$('#range-apply-btn').trigger('tap');
		}
		
		function formatDate(date)
		{
			var month = date.getMonth() + 1;
			var day = date.getDate();
			var year = date.getFullYear();
			
			if(day < 10)
			{
				day = '0' + day;
			}
			if(month < 10)
			{
				month = '0' + month;
			}
			return month + '/' + day + '/' + year;
		}
		
		function verifyDefaultDateRangeButton()
		{
			var range = new Date();
			range.setFullYear(range.getFullYear() -1);

//			var formattedToday = formatDate(new Date());
//			var formattedRange = formatDate(range);
			
			fromDate = $('#filter-date-from').val();
			toDate = $('#filter-date-to').val();
			
			equal($('#filter-range-btn').text(), fromDate + ' - ' + toDate,
					'Verify the range is displayed on the button is 1 year from today');

		}
		
		function clickResetAndValidate()
		{
			$('#Reset-btn').trigger('tap');
			equal($('#filter-status-button .ui-btn-text').text(), 'Active',
					'Verify the status filter is reset');
			equal($('#filter-source-button .ui-btn-text').text(), 'VA, Non-VA',
					'Verify the status filter is reset');
			equal($('#filter-count-button .ui-btn-text').text(), '25',
					'Verify the status filter is reset');
			
			verifyDefaultDateRangeButton();
		}

		
		test('Filter on active or expired', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				expandDateRange();
			}, function() {
				$('#filter-status-button').trigger('click');

				$('.ui-popup-active li:nth-child(2) a').trigger('click'); //open status filter
				ok($('.ui-popup-active li:nth-child(2) .ui-icon-checkbox-on').length === 1,
						'Verify that active is checked');
				ok($('.ui-popup-active li:nth-child(3) .ui-icon-checkbox-on').length === 0,
						'Verify that expired is NOT checked');
				$('.ui-popup-active a').eq(0).trigger('click'); //close status filter pop-up
			}, function() {
				var status = "";
				var medLength = getMedListCount();
				for (var i = 1; i <= medLength; i ++) {
					status = $('#medications-list li:nth-child(' + i +') p').eq(0).find('b').text();
					ok(status === 'ACTIVE', 'Verify the list only contains ACTIVE meds');
				}

			}, function() {
				$('#filter-status-button').trigger('click');

				$('.ui-popup-active li:nth-child(3) a').trigger('click'); //open status filter
				ok($('.ui-popup-active li:nth-child(2) .ui-icon-checkbox-on').length === 1,
						'Verify that active is checked');
				ok($('.ui-popup-active li:nth-child(3) .ui-icon-checkbox-on').length === 1,
						'Verify that expired is checked');
				$('.ui-popup-active a').eq(0).trigger('click'); //close status filter pop-up

				status = "";
				medLength = getMedListCount();
				for (var i = 1; i <= medLength; i ++) {
					status = $('#medications-list li:nth-child(' + i + ') p').eq(0).find('b').text();
					ok(status === 'ACTIVE' || status === 'EXPIRED', 
							'Verify the list contains ACTIVE or EXPIRED meds');
				}
				
			}, function() { 
				$('#filter-status-button').trigger('click');

				$('.ui-popup-active li:nth-child(2) a').trigger('click'); //open status filter
				ok($('.ui-popup-active li:nth-child(2) .ui-icon-checkbox-on').length === 0, 
						'Verify that active is NOT checked');
				ok($('.ui-popup-active li:nth-child(3) .ui-icon-checkbox-on').length === 1, 
						'Verify that expired is checked');
				$('.ui-popup-active a').eq(0).trigger('click'); //close status filter pop-up
				
				status = "";
				medLength = getMedListCount();
				for (var i = 1; i <= medLength; i ++) {
					status = $('#medications-list li:nth-child(' + i + ') p').eq(0).find('b').text();
					ok(status === 'EXPIRED', 'Verify the list only contains EXPIRED meds');
				}
				
				clickResetAndValidate();
			});
		});
		
		test('Filter on VA or Non-VA', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				expandDateRange();
			}, function() {
				$('#filter-status-button').trigger('click');

				$('.ui-popup-active li:nth-child(3) a').trigger('click'); //open status filter
				ok($('.ui-popup-active li:nth-child(2) .ui-icon-checkbox-on').length === 1,
						'Verify that active is checked');
				ok($('.ui-popup-active li:nth-child(3) .ui-icon-checkbox-on').length === 1,
						'Verify that expired is checked');
				$('.ui-popup-active a').eq(0).trigger('click'); //close status filter pop-up

			}, function() {
				$('#filter-source-button').trigger('click');
				ok($('.ui-popup-active li:nth-child(2) .ui-icon-checkbox-on').length === 1, 
						'Verify that VA is checked');
				ok($('.ui-popup-active li:nth-child(3) .ui-icon-checkbox-on').length === 1, 
						'Verify that Non-VA is checked');
				$('.ui-popup-active a').eq(0).trigger('click'); //close status filter pop-up

				source = "";
				medLength = getMedListCount();
				for (var i = 1; i <= medLength; i ++) {
					source = $('#medications-list li:nth-child(' + i + ') td:nth-child(5)').text();
					ok(source === 'VA' || source === 'OTHER' || source === 'DoD', 
							'Verify the list only contains meds from VA and other sources');
				}				
			}, function() { 
				$('#filter-source-button').trigger('click');

				$('.ui-popup-active li:nth-child(3)').trigger('click');
				ok($('.ui-popup-active li:nth-child(2) .ui-icon-checkbox-on').length === 1, 
					'Verify that VA is checked');
				ok($('.ui-popup-active li:nth-child(3) .ui-icon-checkbox-on').length === 0, 
					'Verify that Non-VA is NOT checked');
				$('.ui-popup-active a').eq(0).trigger('click'); //close source filter pop-up
				
				var source = "";
				var medLength = getMedListCount();
				for (var i = 1; i <= medLength; i ++) {
					source = $('#medications-list li:nth-child(' + i + ') td:nth-child(5)').text();
					ok(source === 'VA', 'Verify the list only contains meds from VA');
				}
			}, function() { 
				$('#filter-source-button').trigger('click');

				$('.ui-popup-active li:nth-child(3)').trigger('click');
				$('.ui-popup-active li:nth-child(2)').trigger('click');
				ok($('.ui-popup-active li:nth-child(2) .ui-icon-checkbox-on').length === 0, 
						'Verify that VA is NOT checked');
				ok($('.ui-popup-active li:nth-child(3) .ui-icon-checkbox-on').length === 1, 
						'Verify that Non-VA is checked');
				$('.ui-popup-active a').eq(0).trigger('click'); //close status filter pop-up
				
				source = "";
				medLength = getMedListCount();
				for (var i = 1; i <= medLength; i ++) {
					source = $('#medications-list li:nth-child(' + i + ') td:nth-child(5)').text();
					ok(source === 'OTHER' || source === 'DoD', 'Verify the list only contain non-VA meds');
				}
				
				clickResetAndValidate();
			});
		});
	
		
		test('Verify one year of meds is listed by default', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				var range = new Date();
				range.setFullYear(range.getFullYear() -1);

				verifyDefaultDateRangeButton();
				
				var medListLength = getMedListCount();
				for (var i = 1; i <= medListLength; i ++) {
					var orderDate = new Date($('#medications-list li:nth-child(' + i + ') td:nth-child(4)').text());
					ok(orderDate >= range, 'Verify one year of meds are displayed by default');
				}

			});
		});
		

		test('Filter on date range of initial order date', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#filter-range-btn').trigger('tap');
				return 500;
			}, function() { 
				equal($('#range-menu h3').text(), 'Select Date Range',
						'Verify the title of the pop-up');

				$('#filter-date-from').val('01/01/2013').trigger('change');
				$('#filter-date-to').val('02/02/2013').trigger('change');
				$('#range-apply-btn').trigger('tap');
				return 500;
			}, function() { 
				var medListLength = getMedListCount();
				for (var i = 1; i <= medListLength; i ++) {
					var orderDate = new Date($('#medications-list li:nth-child(' + i + ') td:nth-child(4)').text());
					ok(orderDate >= new Date('01/01/2013') && orderDate <= new Date('02/02/2013'),
							'Verify the date range of medications');
				}

				clickResetAndValidate();
			});
		});
		
		test('Filter on inpatient/outpatient meds', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				if(window.location.href.indexOf('patient-viewer') > 1)
				{
					$('#filter-service-button').trigger('click')
					$('.ui-popup-active li:nth-child(2) a').trigger('click');	
					equal($('#filter-service-button .ui-btn-text span').text(),
							'Outpatient', 'Verify the button label is outpatient');
					
					$('#filter-service-button').trigger('click')
					$('.ui-popup-active li:nth-child(3) a').trigger('click');	
					equal($('#filter-service-button .ui-btn-text span').text(),
							'Inpatient', 'Verify the button label is inpatient');
					
					//Verify that only one filter can be selected at a time
					$('#filter-service-button').trigger('click')
					if($('.ui-popup-active li:nth-child(3).ui-btn-active').length === 1)
					{
						equal($('.ui-popup-active li:nth-child(2).ui-btn-active').length, 0, 
								'Verify that Outpatient is NOT selected if Inpatient is')
					}
					else
					{
						equal($('.ui-popup-active li:nth-child(3).ui-btn-active').length, 1, 
						'Verify that Inpatient is NOT selected if Outpatient is')
					}
					
				}
				else
				{
					ok($('#filter-service-button').length === 0, 'Verify the in/outpatient filter is not displayed');	
				}
			});


		});
		
		test('Filter on number of results returned', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				clickResetAndValidate();
			}, function() { 
				expandDateRange();
			}, function() {
				if(window.location.href.indexOf('patient-viewer') > 1)
				{
					$('#filter-service-button').trigger('click')
					$('.ui-popup-active li:nth-child(3) a').trigger('click');	
					$('.ui-popup-active a').eq(0).trigger('click');
				}
			}, function() {
				//Set the status to include active and expired
				$('#filter-status-button').trigger('click'); 
				$('.ui-popup-active li:nth-child(3) a').trigger('click'); 
				$('.ui-popup-active a').eq(0).trigger('click');
			}, function() { 
				$('#filter-count-button').trigger('click');
				$('.ui-popup-active li:nth-child(2) a').trigger('click');
				equal(getMedListCount(), '10', 'Verify the list is filtered to 10');
			}, function() {
				$('#filter-count-button').trigger('click');
				$('.ui-popup-active li:nth-child(3) a').trigger('click');
				equal(getMedListCount(), '25', 'Verify the list is filtered to 25');
			}, function() {
				$('#filter-count-button').trigger('click');
				$('.ui-popup-active li:nth-child(4) a').trigger('click');
				ok(getMedListCount() > 25 && getMedListCount() <= 50, 'Verify the list is filtered to 50');
			}, function() {
				$('#filter-count-button').trigger('click');
				$('.ui-popup-active li:nth-child(5) a').trigger('click');
				ok(getMedListCount() > 25 && getMedListCount() <= 100, 'Verify the list is filtered to 100');
				
				clickResetAndValidate();
			});
		});
		
		test('Medications are sorted alphabetically within status groups', function() {

			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				var medLength = getMedListCount();
                var medName = "";
                var activeCount = 0;
                var expiredCount = 0;
 
                for (var i = 1; i <= medLength; i ++) {
                    var status = $('#medications-list li:nth-child(' + i + ') p').eq(0).find('b').text();
                    if(status === 'ACTIVE')
                    {
                        //Set the value for the first element in the group
                        if(activeCount === 0)
                        {
                            medName = getMedName(i);    
                        }
                        var nextmedName = getMedName(i);
                        ok(medName <= nextmedName, 'Verify the medications are sorted correctly');
                        medName = nextmedName;
                        activeCount++;
                         
                    }
                    if(status === 'EXPIRED')
                    {
                        //Set the value for the first element in the group
                        if(expiredCount === 0)
                        {
                            medName = getMedName(i);
                        }
                        var nextExpiredMedName = getMedName(i);
                        ok(medName <= nextExpiredMedName, 'Verify the medications are sorted correctly');
                        medName = nextExpiredMedName;
                        expiredCount++;
                    }
                }
			});
			
		});
		
		test('Medication details is scrollable', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				$('#medications-list li:nth-child(2) a').trigger('tap');
                ok($('#content-primary .scrollable').length === 1, 'Verify the primary window is scrollable' );
			});
		});
		
		test('Date Format is correct', function() {
			
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				var lastFilled = $('#medications-list li:nth-child(2) td:nth-child(3)').text();
                var initialOrder = $('#medications-list li:nth-child(2) td:nth-child(4)').text();
                 
                equal(lastFilled, '02/02/2013', 'Verify the format of the last filled date');
                equal(initialOrder, '02/02/2013', 'Verify the format of the initial order');
			});
		});
		
	};
	
	return {
		initialize: defineTests
	};
});
