define([
	'jQuery',
	'testUtilities'
], function($$, testUtilities) {
	var defineTests = function() {

		module("#36948: date range filter for lab graphs");
		
		function clickFooter()
		{
			$('#footer-more-btn').trigger('tap'); 
			$('#footer-lab-results-btn').trigger('tap');
		}

		asyncTest('Verify default time period is 2 years', function() {
			searchAndSelectPatient();
			clickFooter();
			setTimeout(function() {
				start();
				$('#lab-list div:nth-child(1) li:nth-child(1) a').trigger('tap');
				equal($('#date-range-selection .ui-btn-active .ui-btn-text').text(), '2 Years',
					'Verify that the default view is 2 years of lab data');
			}, 200);
		});

		asyncTest('Verify 1m, 6m, 1y, 2y, and custom time periods are available', function() {
			searchAndSelectPatient();
			clickFooter();
			setTimeout(function() {
				start();
				$('#lab-list div:nth-child(1) li:nth-child(3) a').trigger('tap');
				if(window.location.href.indexOf('patient-viewer') > 1)
				{
					equal($('#date-range-selection .ui-block-a').text(), '1 Week',
						'Verify that 1 week time period is available for selection');
					equal($('#date-range-selection .ui-block-b').text(), '1 Month',
						'Verify that 1 month time period is available for selection');
					equal($('#date-range-selection .ui-block-c').text(), '1 Year',
						'Verify that 1 year time period is available for selection');
					equal($('#date-range-selection .ui-block-d').text(), '2 Years',
						'Verify that 2 year time period is available for selection');
					equal($('#date-range-selection .ui-block-e').text(), 'Custom Range',
						'Verify that custom date range is available for selection');
				}
				else
				{
					equal($('#date-range-selection .ui-block-a').text(), '1 Month',
						'Verify that 1 month time period is available for selection');
					equal($('#date-range-selection .ui-block-b').text(), '6 Months',
						'Verify that 6 month time period is available for selection');
					equal($('#date-range-selection .ui-block-c').text(), '1 Year',
						'Verify that 1 year time period is available for selection');
					equal($('#date-range-selection .ui-block-d').text(), '2 Years',
						'Verify that 2 year time period is available for selection');
					equal($('#date-range-selection .ui-block-e').text(), 'Custom Range',
						'Verify that custom date range is available for selection');
				}
					
					
			}, 200);
		});

		asyncTest('Verify that user is able to see what date range tab is currently selected', function() {
			searchAndSelectPatient();
			clickFooter();
			setTimeout(function() {
				start();
				$('#lab-list div:nth-child(1) li:nth-child(3) a').trigger('tap');

				$('#date-range-selection .ui-block-a a').trigger('click');
				ok($('#date-range-selection .ui-block-a .ui-btn-active').length === 1,
					'Verify the first tab is highlighted when user taps it');
				
				$('#date-range-selection .ui-block-b a').trigger('click');
				ok($('#date-range-selection .ui-block-b .ui-btn-active').length === 1,
					'Verify the second tab is highlighted when user taps it');

				$('#date-range-selection .ui-block-c a').trigger('click');
				ok($('#date-range-selection .ui-block-c .ui-btn-active').length === 1,
					'Verify the third tab is highlighted when user taps it');

				$('#date-range-selection .ui-block-d a').trigger('click');
				ok($('#date-range-selection .ui-block-d .ui-btn-active').length === 1,
					'Verify the fourth tab is highlighted when user taps it');

				$('#date-range-selection .ui-block-e a').trigger('click');
				ok($('#date-range-selection .ui-block-e .ui-btn-active').length === 1,
					'Verify that Custom Range tab is highlighted when user taps it');
			}, 200);
		});
		
	};
	
	return {
		initialize: defineTests
	};
});
