define([
	'jQuery',
	'async',
	'asyncSeries',
	'testUtilities'
], function($$, async, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#36933 Detailed lab view graph lab tests");
		
		function tapLab()
		{
			var wbcLab = $('#lab-list div:nth-child(1) li:nth-child(1) a');
			wbcLab.trigger('tap');
		}

		function clickMicro()
		{
			$('#tabView .ui-block-b a').trigger('click');
			$('#tabView .ui-block-b a').trigger('tap');
			ok($('#tabView .ui-block-b .ui-btn-active'));
		}
		
		function clickFooter()
		{
			$('#footer-more-btn').trigger('tap'); 
			$('#footer-lab-results-btn').trigger('tap');
		}

		test('Verify x/y axis data', function() {
			stop();
			async.series([function(next) {
				searchAndSelectPatient();
				
				setTimeout(next, 1000);
			}, function(next) {
				clickFooter();

				setTimeout(next, 1000);
			}, function(next) {
				tapLab();

				setTimeout(next, 1000);
			}, function(next) {

				var yAxis = $('#graph .highcharts-axis-labels').eq(1).find('tspan');
				var xAxis = $('#graph .highcharts-axis-labels').eq(0).find('tspan');
				
				//Verify the X-axis is alphanumeric, indicating that it contains month and year
				ok(/^[A-Za-z0-9]/.test(xAxis.text()));
				
				//Verify the Y-axis is numeric, indicating that it only contains the range
				ok(/^[0-9]/.test(yAxis.text()));
				
				next();
			}], start);
		});

		test('Verify the title of the graph', function() {
			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				tapLab();
			}, function() {
				equal($('legend').text(), 'WBC (BLOOD)', 
				'Verify the abbreviated lab name is the title of the graph');
			});
		});
		
		test('Verify that no graph is displayed upon landing on chem/hem', function() {

			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				equal($("#graph").length, 0, 'Verify that the graph element does not exist');
				tapLab();
			}, function() {
				equal($("#graph").length, 1, 'Verify that tapping a lab displays the graph');
				
				clickMicro();
			}, function() {
				equal($("#graph").length, 0, 
				'Verify that the graph is not displayed after navigating to microbiology');
			});
		});


	};
	
	return {
		initialize: defineTests
	};
});
