define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#36919 Detailed Lab View");
		
		function clickFooter()
		{
			$('#footer-more-btn').trigger('tap');
			$('#footer-lab-results-btn').trigger('tap');
			
			return 500;
		}
		
		test('Verify the list of lab results', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				ok($('#content-secondary .ui-header h3').text(), 'Lab Results');
				var cbcProfile = $('#lab-list div:nth-child(1) h2 .ui-btn-text').contents(':not(.ui-collapsible-heading-status)').text();
				var chemProfile = $('#lab-list div:nth-child(2) h2 .ui-btn-text').contents(':not(.ui-collapsible-heading-status)').text();
				//Verify the button text that corresponds to the defined groupings in the labgrouserver.xml file
				equal(cbcProfile,'Complete Blood Count (CBC) (8)',	'Verify the pre-defined section is displayed correctly');
				equal(chemProfile,'Chemistry (7)', 'Verify the pre-defined section is displayed correctly');
			});
		});
		
		test('Verify that labs are grouped within defined groups', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				ok($('#lab-list div:nth-child(1) li').length > 1, 'Verify the first lab group has more than 3');
				ok($('#lab-list div:nth-child(2) li').length > 1, 'Verify the second lab group has more than 10');
			});

		});
		
		test('Verify tests within a lab group are sorted according to the config file', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				equal($('#lab-list div:nth-child(1) li:nth-child(1) a h3').text(), 'WBC (BLOOD)', 'Verify that WBC appears first in the list');
				equal($('#lab-list div:nth-child(1) li:nth-child(2) a h3').text(), 'RBC (BLOOD)','Verify that RBC appears second in the list');
			});
		});

		test('Verify that only lab groups for which the patient has labs are displayed', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				var labGroups = $('#lab-list div h2 .ui-btn-text').contents(':not(.ui-collapsible-heading-status):contains(TOXICOLOGY)').length;
				ok(labGroups === 0,'Verify that TOXICOLOGY is not listed in the lab groups since the patient has no toxicology labs');
			});
		});
		
		test('Verify section can be expanded and collapsed', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				if(!$('#lab-list div:nth-child(1) h2').hasClass('ui-collapsible-heading-collapsed'))
				{
					$('#lab-list div:nth-child(1) h2 a').trigger('click');
				}
				ok($('#lab-list div:nth-child(1) h2').hasClass('ui-collapsible-heading-collapsed'), 'Verify that the group is collapsed');
				$('#lab-list div:nth-child(1) h2 a').trigger('click');
				ok(!$('#lab-list div:nth-child(1) h2').hasClass('ui-collapsible-heading-collapsed'), 'Verify that the group is expanded');
			});
		});
		
		
		test('Verify alphabetical sort order for miscellaneous lab tests', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				var miscTestsLength = $('#lab-list div:nth-child(4) li').length;
				ok(miscTestsLength > 0, 'Misc Tests is not empty');
				
				var labName = $('#lab-list div:nth-child(4) li:nth-child(1) a').children().eq(1).text();
				
				for (var i = 1; i <= miscTestsLength; i ++) {
					var nextLabName = $('#lab-list div:nth-child(4) li:nth-child(' + i + ') a').children().eq(2).text();
					
					ok(labName <= nextLabName, 'Verify the lab is sorted correctly');
					labName = nextLabName;
				}
			});
		});
		
		test('Verify threshold values appear differently', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				ok($('#lab-list div:nth-child(1) li:nth-child(1) span').hasClass('status-ok'), 'Threshold is within defined range');
				ok($('#lab-list div:nth-child(1) li:nth-child(2) span').hasClass('status-abnormal'), 'Threshold is outside of defined range');
				ok($('#lab-list div:nth-child(1) li:last span').hasClass('status-no-reference'), 'No reference threshold defined');
			});
		});
		
	};
	
	return {
		initialize: defineTests
	};
});
