define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#39611 Convert MBB to jQM/Backbone");

		var gotoSectionList = function() {
			waitForElement($('#duration-list'));
			var durationList = $('#duration-list');
			durationList.find('li:first-child a').trigger('tap');
			
			waitForElement($('#section-list'));
			var sectionList = $('#section-list');
			ok($('#section-list').is(':visible'), 'Section List is visible');
			
			return sectionList;
		};
		test('Select Contact Information domain', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Contact Information"]');
			item.trigger('tap');
			waitForElement($('#content-primary .expander[title="Contact Information"]'));
			
			var moduleTitle = $('#content-primary .expander[title="Contact Information"]').find('h3').text().trim();
			ok(item.find('span').hasClass('ui-icon-checkbox-on'), 'Contact Information list item is checked');
			equal(moduleTitle, 'patient66, zztest', 'Contact Information domain title is shown');
		});
		test('Select Medical Diagnoses domain', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Medical Diagnoses"]');
			item.trigger('tap');
			waitForElement($('#content-primary .expander[title="Medical Diagnoses"]'));
			
			var moduleTitle = $('#content-primary .expander[title="Medical Diagnoses"]').find('h3').text().trim();
			ok(item.find('span').hasClass('ui-icon-checkbox-on'), 'Medical Diagnoses list item is checked');
			equal(moduleTitle, 'Medical Diagnoses', 'Medical Diagnoses domain title is shown');
		});
		test('Select Allergies domain', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Allergies"]');
			item.trigger('tap');
			waitForElement($('#content-primary .expander[title="Allergies"]'));

			var moduleTitle = $('#content-primary .expander[title="Allergies"]').find('h3').text().trim();
			ok(item.find('span').hasClass('ui-icon-checkbox-on'), 'Allergies list item is checked');
			equal(moduleTitle, 'Allergies', 'Allergies domain title is shown');
		});
		test('Select Medications domain', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Medication List"]');
			item.trigger('tap');
			waitForElement($('#content-primary .expander[title="Medication List"]'));
			
			var buttonLabel = $('#section-list').find('a[title="Medication List"] h3').text();
			var moduleTitle = $('#content-primary .expander[title="Medication List"]').find('h3').text().trim();
			ok(item.find('span').hasClass('ui-icon-checkbox-on'), 'Medications list item is checked');
			equal(buttonLabel, 'Medication List', 'Verify the label of the Medication List button');
			equal(moduleTitle, 'Medication List', 'Medications domain title is shown');
			
		});
		test('Select Surgeries domain', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Surgeries"]');
			item.trigger('tap');
			waitForElement($('#content-primary .expander[title="Surgeries"]'));

			var moduleTitle = $('#content-primary .expander[title="Surgeries"]').find('h3').text().trim();
			ok(item.find('span').hasClass('ui-icon-checkbox-on'), 'Surgeries list item is checked');
			equal(moduleTitle, 'Surgeries', 'Surgeries domain title is shown');
		});
		test('Select Vitals domain', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Vitals"]');
			item.trigger('tap');
			waitForElement($('#content-primary .expander[title="Vitals"]'));
			
			var moduleTitle = $('#content-primary .expander[title="Vitals"]').find('h3').text().trim();
			ok(item.find('span').hasClass('ui-icon-checkbox-on'), 'Vitals list item is checked');
			equal(moduleTitle, 'Vital Signs - From VA Medical Entry', 'Vitals domain title is shown');
		});
		test('Select Medication History domain', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Medication History"]');
			item.trigger('tap');
			waitForElement($('#content-primary .expander[title="Medication History"]'));
			
			var moduleTitle = $('#content-primary .expander[title="Medication History"]').find('h3').text().trim();
			ok(item.find('span').hasClass('ui-icon-checkbox-on'), 'Medication History list item is checked');
			equal(moduleTitle, 'Medication History', 'Medication History domain title is shown');
		});

		test('Select Lab Results domain', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Lab Results"]');
			item.trigger('tap');
			waitForElement($('#content-primary .expander[title="Lab Results"]'));
			
			var moduleTitle = $('#content-primary .expander[title="Lab Results"]').find('h3').first().text().trim();
			ok(item.find('span').hasClass('ui-icon-checkbox-on'), 'Chemistry Labs list item is checked');
			equal(moduleTitle, 'Lab Results', 'Labs domain title is shown');
			equal($('#content-primary [title="Lab Results"]').children().eq(3).find('p').eq(1).text(),
				'Facility: no data found',
				'Verify the facility for the lab result');
		});
		
		test('Verify labs are sorted in reverse-chronological order', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Lab Results"]');
			item.trigger('tap');
			var labListLength = $('#content-primary .expander[title="Lab Results"]').children().length;
			var previousDate = new Date($('#content-primary .expander[title="Lab Results"]').children().eq(1).find('p').text().substring(14,26));
			
			for (var i = 1; i < labListLength; i ++) {
				var labDate = new Date($('#content-primary .expander[title="Lab Results"]').children().eq(i).find('p').text().substring(14,26));

				ok(previousDate >= labDate, 'Previous date is greater than or equal to current date (reverse chronological order)');
				previousDate = labDate;
			}
		});
		
		test('Select Radiology Reports domain', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Radiology Exams"]');
			item.trigger('tap');
			var moduleTitle = $('#content-primary .expander[title="Radiology Exams"]').find('h3').first().text().trim();
			ok(item.find('span').hasClass('ui-icon-checkbox-on'), 'Radiology Exams list item is checked');
			equal(moduleTitle, 'Radiology Reports', 'Radiology Exams domain title is shown');
		});
		test('Select Outpatient Clinic Notes domain', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Clinical Notes"]');
			item.trigger('tap');
			var moduleTitle = $('#content-primary .expander[title="Clinical Notes"]').find('h3').first()    .text().trim();
			ok(item.find('span').hasClass('ui-icon-checkbox-on'), 'Clinical Notes list item is checked');
			equal(moduleTitle, 'Outpatient Clinic Notes', 'Clinical Notes domain title is shown');
		});
		test('Select Discharge Summaries domain', function() {
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Discharge Summaries"]');
			item.trigger('tap');
			var moduleTitle = $('#content-primary .expander[title="Discharge Summaries"]').find('h3').eq(0).text().trim();
			ok(item.find('span').hasClass('ui-icon-checkbox-on'), 'Discharge Summaries list item is checked');
			equal(moduleTitle, 'Hospital Discharge Summaries', 'Discharge Summaries domain title is shown');

		});
		
		test('Share data domains display in correct order', function() {
			var sectionList = gotoSectionList();
			var firstItem = sectionList.find('li:nth-child(2) a');
			var firstItemText = firstItem.text().trim();
			var secondItem = sectionList.find('li:nth-child(3) a');
			var secondItemText = secondItem.text().trim();
			var thirdItem = sectionList.find('li:nth-child(4) a');
			var thirdItemText = thirdItem.text().trim();

			firstItem.trigger('tap');
			var firstModule = $('#content-primary .expander:nth-child(3)');
			firstModuleTitle = firstModule.attr('title');
			equal(firstItemText, firstModuleTitle, 'First Module first in order');

			thirdItem.trigger('tap');
			var thirdModule = $('#content-primary .expander:nth-child(4)');
			thirdModuleTitle = thirdModule.attr('title');
			equal(thirdItemText, thirdModuleTitle, 'Third Module second in order');

			secondItem.trigger('tap');
			var secondModule = $('#content-primary .expander:nth-child(4)');
			secondModuleTitle = secondModule.attr('title');
			equal(secondItemText, secondModuleTitle, 'Second Module second in order');
		});
		test('Select all domains with single selection', function() {
			var sectionList = gotoSectionList();
			ok($('#All-btn').text().trim() == 'All', 'All button is ready');
			$('#All-btn').trigger('tap');
			var sectionListItemCount = sectionList.find('li:not(.ui-li-divider)').length;
			var sectionListCheckedItems = sectionList.find('.ui-icon-checkbox-on').length;
			var moduleItemsCount = $('#content-primary').find('section.expander').length;
			equal(sectionListCheckedItems, sectionListItemCount, 'All list items are checked');
			equal(moduleItemsCount-1, sectionListItemCount, 'All domains and confidential message are shown');
		});
		test('Deselect all domains with single selection', function() {
			var sectionList = gotoSectionList();
			ok($('#All-btn').text().trim() == 'All', 'All button is ready');
			$('#All-btn').trigger('tap');
			ok($('#All-btn').text().trim() == 'None', 'None button is ready');
			$('#All-btn').trigger('tap');
			var sectionListItemCount = sectionList.find('li:not(.ui-li-divider)').length;
			var sectionListCheckedItems = sectionList.find('.ui-icon-checkbox-on').length;
			var moduleItemsCount = $('#content-primary').find('.expander').length;
			equal(sectionListCheckedItems, 0, 'No list items are checked');
			equal(moduleItemsCount-1, 0, 'No domains are shown, confidential message remains');
		});
		
		test('Verify that canceling the custom date range does not add any Durations', function(){
			var durationListCount = $('#duration-list li').length;
			$('#Range-btn').trigger('tap');
			$('#custom-date-menu a').trigger('click');
			equal($('#duration-list li').length, durationListCount, 'Verify that only two default durations exist');
		});
		
		test('Verify that dates over 6 years cannot be selected for custom durations', function(){
			$('#Range-btn').trigger('tap');
			$('form [name=startDate]').val('10/10/2006').trigger('change');
			$('form [name=endDate]').val('11/10/2012').trigger('change');
			$('#date-from').datebox('open');
			equal($('.ui-datebox-griddate-disable').length, 31, 'Verify that all days over 6 years are disabled');
			$('.ui-datebox-container a').trigger('click');
			$('#custom-date-menu a').trigger('click');
			//Wait for the calendar control to close
			stop();
			setTimeout(function() {
				start();
			}, 1000);

		});
		
		test('Verify that dates under 6 years can be selected for custom durations', function(){
			$('#Range-btn').trigger('tap');
			$('form [name=startDate]').val('12/10/2006').trigger('change');
			$('form [name=endDate]').val('11/10/2012').trigger('change');
			$('#date-from').datebox('open');
			equal($('.ui-datebox-griddate-disable').length, 0, 'Verify that all days under 6 years are enabled');
			$('.ui-datebox-container a').trigger('click');
			$('#custom-date-menu a').trigger('click');
			//Wait for the calendar control to close
			stop();
			setTimeout(function() {
				start();
			}, 1000);
		});
		
		test('Verify that the startDate is cleared if the endDate is set to a date prior to the startDate', function(){
			$('#Range-btn').trigger('tap');
			$('form [name=startDate]').val('10/20/2012').trigger('change');
			$('form [name=endDate]').val('10/10/2012').trigger('change');
			equal($('form [name=startDate]').val(), "", 'Verify that the start date is cleared when the end date is set to an earlier date');
			$('.ui-datebox-container a').trigger('click');				
		});
		
		test('Verify that start dates are not selectable after the end date', function(){
			$('#Range-btn').trigger('tap');
			$('form input[name=startDate]').val('10/10/2012').trigger('change');
			$('form input[name=endDate]').val('10/10/2012').trigger('change');
			$('#date-from').datebox('open');
			//Wait for the calendar control to open
			stop();
			setTimeout(function() {
				start();
			}, 500);
			equal($('.ui-datebox-griddate-disable').length, 21, 'Verify that all dates after the end date are disabled');	
			$('.ui-datebox-container a').trigger('click');
			$('#custom-date-menu a').trigger('click');
			//Wait for the calendar control to close
			stop();
			setTimeout(function() {
				start();
			}, 1000);
		});

		test('Verify that a custom date range can be added successfully and that the date range is displayed correctly', function(){
			$('#Range-btn').trigger('tap');
			$('#date-from').datebox('open');
			$('form input[name=startDate]').val('11/10/2009').trigger('change');
			$('#date-from').datebox('open');
			$('form input[name=endDate]').val('10/10/2012').trigger('change');
			$('#add-custom-date').trigger('tap');
			equal($('#duration-list li:nth-child(3)').find('h3').text().trim(), "11/10/2009  -  10/10/2012", 'Verify that the custom duration was added');
			var durationList = $('#duration-list');
			durationList.find('li:nth-child(3) a').trigger('tap');
			equal($('.ui-li-divider').text(), "11/10/2009  -  10/10/2012", 'Verify the domain header corresponds to the duration selected');
		});
		
		test('Validate 1 year duration', function(){
			var durationList = $('#duration-list');
			durationList.find('li:first-child a').trigger('tap');
			equal($('.ui-li-divider').text(), "1 Year", 'Verify the domain header corresponds to the duration selected');			
		});
		
		test('Validate 2 year duration', function(){
			var durationList = $('#duration-list');
			durationList.find('li:nth-child(2) a').trigger('tap');
			equal($('.ui-li-divider').text(), "2 Year", 'Verify the domain header corresponds to the duration selected');			
		});
		
		test('Validate that no new durations are added if date ranges where other date ranges were previously selected and canceled', function(){
			var durationListCount = $('#duration-list li').length;
			$('#Range-btn').trigger('tap');
			$('#date-from').datebox('open');
			$('form input[name=startDate]').val('11/10/2009').trigger('change');
			$('#date-from').datebox('open');
			$('form input[name=endDate]').val('10/10/2012').trigger('change');
			$('.ui-datebox-container a').trigger('click');
			$('#custom-date-menu a').trigger('click');
			//Wait for the calendar control to close
			stop();
			setTimeout(function() {
				start();
			}, 1000);
			$('#Range-btn').trigger('tap');
			$('#date-from').datebox('open');
			$('form input[name=startDate]').val('11/10/2008').trigger('change');
			$('#date-from').datebox('open');
			$('form input[name=endDate]').val('10/10/2012').trigger('change');
			$('#add-custom-date').trigger('tap');
			equal($('#duration-list li').length, durationListCount + 1, 'Verify that only two default durations exist');
		});

		test('Verify confidential message text', function(){
			var paragraphText = 'This summary is a copy of information from your Mobile Blue Button App. ' +
			'This summary contains information from VA health systems that was available on the date requested. ' + 
			'The primary data source for the summary is updated nightly for all areas in this report except for ' + 
			'radiology reports which are updated weekly. Additionally, to ensure your healthcare team has had time ' +
			'to review reports there may be a time delay for the display of some information.';		
			
			equal($('#confidential h3').text(), 'Confidential', 'Verify confidential header');
			equal($('#confidential p').eq(0).text().trim(), 
					'Produced by the VA Mobile Blue Button App', 
					'Verify the MBB text');
			equal($('#confidential p').eq(1).text().trim().replace(/\s+/g, ' '), paragraphText,
					'Verify the paragraph text');
			equal($('#confidential p').eq(2).text().trim(), 'General Information',
					'Verify the paragraph text');
			equal($('#confidential li:nth-child(1)').text(), 
					'The Table of Contents (in PDF) lists areas that you requested to included in this summary.',
					'Verify the bullet 1 text');
			equal($('#confidential li:nth-child(2)').text(), 
					"Information in the \u201cCurrent/Active\u201d section (in PDF) shows current information regardless of date range.",
					'Verify the bullet 2 text');
			equal($('#confidential li:nth-child(3)').text(), 
					'Time limited information shows more detailed information for the selected date range.',
					'Verify the bullet 3 text');
			equal($('#confidential p').eq(4).text().trim(), 
					'Please let your healthcare team know if you have questions about your health information.',
					'Verify the paragraph text');

		});
		
		test('Verify standalone date format', function(){
			gotoSectionList();
			$('#All-btn').trigger('tap');	

			equal($('#summary-demographics aside [name="dob"]').text().substring(0,11),
					'01 Jan 1900', 'Verify the dob format');
			equal($('#content-primary [title="Lab Results"]').children().eq(2).find('p').eq(0).text(),
					'Resulted Date: 29 Jan 2013',
					'Verify the format of lab result date');
		});

		test('Verify date format within tables', function(){
			gotoSectionList();
			$('#All-btn').trigger('tap');	

			equal($('#content-primary [title="Radiology Exams"] table').eq(0).find('tr').eq(0).find('td').eq(1).text(),
					'06/01/2012 00:00',
					'Verify the format of radiology exam dates');
			equal($('#content-primary [title="Clinical Notes"] table').eq(0).find('tr').eq(0).find('td').eq(1).text(),
					'12/12/2012 08:30',
					'Verify the date format for clinical notes');
			equal($('#content-primary [title="Discharge Summaries"] table').eq(0).find('tr').eq(0).find('td').eq(1).text(),
					'07/12/2012',
					'Verify the date format for discharge summaries');
			equal($('#Vitals-table tr:nth-child(2) td:nth-child(1)').text(),
					'09/23/2012', 'Verify the date format for vitals table');
			equal($('#Surgeries-table tr:nth-child(2) td:nth-child(2)').text(),
					'01/01/2011', 'Verify the date format for surgeries');
		});
		
		test('Verify Updated: Nightly appears in the correct locations', function(){
			gotoSectionList();
			$('#All-btn').trigger('tap');	
			equal($('#content-primary [title="Medical Diagnoses"] p').eq(0).text().trim(),
					'Updated: Nightly', 'Verify Updated: Nightly appears');
			equal($('#content-primary [title="Allergies"] p').eq(0).text().trim(),
					'Updated: Nightly', 'Verify Updated: Nightly appears');
			equal($('#content-primary [title="Medication History"] p').eq(0).text().trim(),
					'Updated: Nightly', 'Verify Updated: Nightly appears');
			equal($('#content-primary [title="Lab Results"] p').eq(0).text().trim(),
					'Updated: Nightly', 'Verify Updated: Nightly appears');
			equal($('#content-primary [title="Discharge Summaries"] p').eq(0).text().trim(),
					'Updated: Nightly', 'Verify Updated: Nightly appears');
			equal($('#content-primary [title="Surgeries"] p').eq(0).text().trim(),
					'Updated: Nightly', 'Verify Updated: Nightly appears');
			equal($('#content-primary [title="Clinical Notes"] p').eq(0).text().trim(),
					'Updated: Nightly', 'Verify Updated: Nightly appears');
		});
		
		test('Verify Updated Weekly appears in the correct locations', function(){
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Radiology Exams"]');
			item.trigger('tap');
			
			equal($('#content-primary [title="Radiology Exams"] p').text(),
					'Updated: Weekly', 'Verify updated weekly appears');

			equal($('#content-primary [title="Radiology Exams"] h3').eq(1).text(),
					'Radiology Report', 'Verify Radiology Reports appears');
		});

		test('Verify the summary line is not displayed in radiology reports', function(){
			ok($('#content-primary [title="Radiology Exams"] td:contains("Summary")').length === 0,
					'Verify the radiology does not have a summary element');
		});

		test('Verify the content format of the medication list', function(){
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Medication History"]');
			item.trigger('tap');

			equal($('#content-primary [title="Medication History"] p').eq(1).text().trim(),
					'5-fluorouracil', 'Verify the drug name is listed');
			equal($('#content-primary [title="Medication History"] p').eq(2).text().trim().replace(/\s+/g, ' '),
					'Status ACTIVE', 'Verify the status is listed');
			equal($('#content-primary [title="Medication History"] p').eq(3).text().trim().replace(/\s+/g, ' '),
					'Directions TAKE ONE AT NIGHT BEFORE GOING TO BED', 'Verify the directions');
			equal($('#content-primary [title="Medication History"] th').eq(0).text(),
					'Quantity', 'Verify the headings for the medication list');
			equal($('#content-primary [title="Medication History"] th').eq(1).text(),
					'Refills', 'Verify the headings for the medication list');
			equal($('#content-primary [title="Medication History"] th').eq(2).text(),
					'Last filled', 'Verify the headings for the medication list');
			equal($('#content-primary [title="Medication History"] th').eq(3).text(),
					'Initial order', 'Verify the headings for the medication list');
			equal($('#content-primary [title="Medication History"] th').eq(4).text(),
					'Source', 'Verify the headings for the medication list');


		});

		
		test('Verify No associated report found is displayed if no radiology report text exists', function(){
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Radiology Exams"]');
			item.trigger('tap');

			equal($('#content-primary [title="Radiology Exams"] .note-section').eq(0).text().trim(),
					'No associated report found', 'Verify the message when no report text exists');
		});

		test('Verify No associated note found is displayed if no clinical note text exists', function(){
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Clinical Notes"]');
			item.trigger('tap');

			equal($('#content-primary [title="Clinical Notes"] .note-section').eq(0).text().trim(),
					'No associated note found', 'Verify the message when no report text exists');
			
		});

		test('Verify No associated note found is displayed if no discharge summary text exists', function(){
			var sectionList = gotoSectionList();
			var item = sectionList.find('a[title="Discharge Summaries"]');
			item.trigger('tap');

			equal($('#content-primary [title="Discharge Summaries"] .note-section').eq(0).text().trim(),
					'No associated note found', 'Verify the message when no report text exist');
		});

	};
	
	return {
		initialize: defineTests
	};
});
