define([
	'jQuery',
	'Underscore'
], function($$, Underscore) {
	var defineTests = function() {
		var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;
		var serverAppNames = [],
			serverLinkNames = [];


		//***** FUNCTIONS ******//
		function getItemsFromServerByType () {

			$$.ajax({
				url:"../../rest/public/launchpad/metadata",
				dataType:"json",
				success: function(data) {

					_.each(data.item, function(item) {
						if (item.type === "APP") {
							serverAppNames.push(item.name);
						}
						else if(item.type === "LINK") {
							serverLinkNames.push(item.name);
						}
					});
				}
			});

		}

		function crosscheckItemsWithServer (items, type) {

			if (type=='app'){
				if (items.length === serverAppNames.length){
					ok(true, "Both Server and Page have the same number of apps");
				}
				items.each(function(currentItem) {

					var currentName = $(this).find("h2").text();
					
					ok(_.contains(serverAppNames, currentName), 
						"Both Server and Page have the app " + currentName);
				});

			} else if (type=='link') {
				if (items.length === serverLinkNames.length){
					ok(true, "Both Server and Page have the same number of links");
				}
				items.each(function(currentItem) {

					var currentName = $(this).find("h2").text();
					
					ok(_.contains(serverLinkNames, currentName), 
						"Both Server and Page have the link " + currentName);
				});
			}
		}
		
		//***** TESTS *****//
		module("#39549 jQM Launchpad: inital state");

		test('Initially logged in', function() {

			ok($('#footer-logout-btn').is(':visible'), 
				"Login/Logout button is visible");

			stop();
			setTimeout(function() {
				equal($("#footer-logout-btn").text().trim(), 'Logout',
					"Login/Logout button shows as 'Logout'");
	
				equal($("#footer-username").text().trim(), 'Logged in as patient66, zztest',
					"Logged in name is shown as '<Last name>, <First name>");

				start();
			}, 2000);
			
		});

//		---------------------------------------------------------------------
		
		module("#39549 jQM Launchpad: filter", {
			setup: function() {
				getItemsFromServerByType();
			},
			teardown: function() {
				serverAppNames = [];
				serverLinkNames = [];
			}
		});

		test("Show All", function() {

			ok($("#footer a[data-filter='*']").is(":visible"),
				"Given the Show All button is visible");

			ok($("#footer a[data-filter='*']").trigger('tap'),
				"When I tap on the Show All button");

			stop();
			setTimeout(function() {
				// Validate Apps
				var allApps = $("#container .app");
				var hiddenApps = $("#container .app.isotope-hidden");
				var visibleApps = $("#container .app:not('.isotope-hidden')");
	
				crosscheckItemsWithServer(allApps, 'app');
	
				equal(allApps.length, visibleApps.length,
					"All the App buttons are visible");
				equal(hiddenApps.length, 0,
					"And there are no hidden Apps");
				
	
				// Validate Links
				var allLinks = $("#container .link");
				var hiddenLinks = $("#container .link.isotope-hidden");
				var visibleLinks = $("#container .link:not('.isotope-hidden')");
	
				crosscheckItemsWithServer(allLinks, 'link');
	
				equal(allLinks.length, visibleLinks.length,
					"All the Link buttons are visible");
				equal(hiddenLinks.length, 0,
					"And there are no hidden Links");
				start();
			}, 2000);

		});

		test("Apps", function() {

			ok($("#footer a[data-filter='.app']").is(":visible"),
				"Given the Apps button is visible");

			ok($("#footer a[data-filter='.app']").trigger('tap'),
				"When I tap on the Apps button");

			stop();
			setTimeout(function() {
				// Validate Apps
				var allApps = $("#container .app");
				var hiddenApps = $("#container .app.isotope-hidden");
				var visibleApps = $("#container .app:not('.isotope-hidden')");
	
				crosscheckItemsWithServer(allApps, 'app');
	
				equal(allApps.length, visibleApps.length,
					"All the App buttons are visible");
				equal(hiddenApps.length, 0,
					"And there are no hidden Apps");
	
				
				// Validate Links
				var allLinks = $("#container .link");
				var hiddenLinks = $("#container .link.isotope-hidden");
				var visibleLinks = $("#container .link:not('.isotope-hidden')");
	
				crosscheckItemsWithServer(allLinks, 'link');
	
				equal(allLinks.length, hiddenLinks.length,
					"All Link buttons hidden");
				equal(visibleLinks.length, 0,
					"And there are no visible Links");
				start();
			}, 2000);
		});

		test("Links", function() {

			ok($("#footer a[data-filter='.link']").is(":visible"),
				"Given the Links button is visible");

			ok($("#footer a[data-filter='.link']").trigger('tap'),
				"When I tap on the Links button");

			stop();
			setTimeout(function() {
				// Validate Links
				var allLinks = $("#container .link");
				var hiddenLinks = $("#container .link.isotope-hidden");
				var visibleLinks = $("#container .link:not('.isotope-hidden')");
	
				crosscheckItemsWithServer(allLinks, 'link');
	
				equal(allLinks.length, visibleLinks.length,
					"All the Link buttons are visible");
				equal(hiddenLinks.length, 0,
					"And there are no hidden Links");
	
	
				// Validate Apps
				var allApps = $("#container .app");
				var hiddenApps = $("#container .app.isotope-hidden");
				var visibleApps = $("#container .app:not('.isotope-hidden')");
	
				crosscheckItemsWithServer(allApps, 'app');
	
				equal(allApps.length, hiddenApps.length,
					"All App buttons are hidden");
				equal(visibleApps.length, 0,
					"And there are no visible Apps");
				start();
			}, 2000);
		});

//		---------------------------------------------------------------------
		
		module("#39549 jQM Launchpad: login/logout");

		test('Logout/Login function', function() {

			equal($("#footer-logout-btn").text().trim(), 'Logout',
				"Login/Logout button shows as 'Logout'");
			
			ok($('#footer-logout-btn').trigger('tap'),
				"When I tap Logout");

			// redirection to page requires two stops, since start is called on iframe's load
			stop();
			stop();
			setTimeout(function() {
				start();
			
				$ = jQuery = window.frames[0].jQuery;
				
				equal($("#footer-logout-btn").text().trim(), 'Login',
						"Login/Logout button shows as 'Login'");
				
				equal($("#footer-username").text().trim(), "Not logged in",
						"Username bar informs user they are NOT logged in");

				ok($('#footer-logout-btn').trigger('tap'),
					"When I tap the Login button");
				
				// redirection to page requires two stops, since start is called on iframe's load
				stop();
				stop();
				setTimeout(function() {
					start();

					ok($("#logonForm").is(":visible"),
							"Then I can see the Login form");

					$("#name-c").val('zztest.patient66');
					$("#password").val('pass');

					ok($("#loginButton").trigger('click'),
						"When I log in as 'zztest patient66'");
					
					// redirection to page requires two stops, since start is called on iframe's load
					stop();
					stop();
					setTimeout(function() {
						start();

						equal($("#header h1").text(), "Launchpad",
							"Then I can see the Launchpad");
						
						equal($("#footer-logout-btn").text().trim(), 'Logout',
							"Login/Logout button shows as 'Logout'");

						equal($("#footer-username").text().trim(), 'Logged in as patient66, zztest',
							"Logged in name is shown as '<Last name>, <First name>");
					}, 2000);
				}, 2000);
			}, 2000);
		});

		
//		---------------------------------------------------------------------
		
	};
	
	return {
		initialize: defineTests
	};
});
