define([
	'jQuery',
	'Underscore'
], function($$, Underscore) {
	var defineTests = function($) {
		var jQuery = $;


		//***** FUNCTIONS ******//
		function login () {
			ok($('#loginlogout').trigger('tap'),
					"When I tap the Login button");

				stop(); 
				setTimeout(function() {
					start();
					$ = jQuery = window.frames[0].jQuery;

					ok($("#logonForm").is(":visible"),
							"Then I can see the Login form");

					$("#name-c").val('zztest.patient66');
					$("#password").val('pass');

					ok($("#loginButton").trigger('click'),
						"When I log in as 'zztest patient66'");

					stop(); 
					setTimeout(function() {
						start();
						$ = jQuery = window.frames[0].jQuery;


							equal($("#header h1").text(), "Launchpad",
								"Then I can see the Launchpad");	// bad
							
							equal($("#loginlogout").text().trim(), 'Logout',
								"Login/Logout button shows as 'Logout'");	// bad

							equal($("#footer-username").text().trim(), 'Logged in as patient66, zztest',
								"Logged in name is shown as '<Last name>, <First name>");	// bad

					}, 2000);
				}, 2000);
		}

		module("#37096: Calendar Instructions");

		test('No instructions (logged out)', function() {
			console.log("No instructions logged out");

			equal($("#loginlogout").text().trim(), 'Logout',
				"Login/Logout button shows as 'Logout'");
			
			ok($('#loginlogout').trigger('tap'),
				"When I tap Logout");
			

			stop(); 
			setTimeout(function() {
				start();
				$ = jQuery = window.frames[0].jQuery;
				
				equal($("#loginlogout").text().trim(), 'Login',
					"Login/Logout button shows as 'Login'");

				equal($("#footer-username").text().trim(), "Not logged in",
					"Username bar informs user they are NOT logged in");

				ok($('#about-btn').is(':visible'),
					"About button is visible");

				ok($('#about-btn').trigger('tap'),
					"When I tap the About button");

				stop();
				setTimeout(function() {
					start();
					ok($('#about').is(':visible'),
						"On the About page");

					ok($('#about-ok-btn').trigger('tap'),
						"When I tap the OK button");

					stop();
					setTimeout(function() {
						start();
						ok($('#main').is(':visible'),
							"Main page is visible");

						login();

					}, 2000);

				}, 1000);
				
			}, 2000);

		});

		test('Section exists in About', function() {

			console.log($('#main'));
			console.log($('#footer-username:contains("Not logged in")'));
			console.log($('#about-btn'));

			ok($('#about-btn').is(":visible"),
				'I can see the About button');

			ok($('#about-btn').trigger('mousedown').trigger('tap').trigger('mouseup'),
				'When I tap the About button');

			stop();
			setTimeout(function() {
				start();
				ok($('#about').is(':visible'),
					'Then I can see the About dialog');

				ok($('#about h2:contains("About")').is(':visible'),
					'Then I can see the About dialog header');

				ok($('#about-ok-btn').is(':visible'),
					'Then I can see the About OK button');

				ok($('#about-ok-btn').trigger('tap'),
					'When I click the About OK button');

				stop();
				setTimeout(function() {
					start();
					ok($('#main').is(':visible'),
						'Then I can see the Main launchpad page');
				}, 2000);
			}, 2000);

		});

		test('Instructions (logged in)', function() {

			ok(true);

		});
		test('blank', function(){ok(true);});

		
		//***** TESTS *****//
		
		

//		---------------------------------------------------------------------
		
	};
	
	return {
		initialize: defineTests
	};
});