define([
	'jQuery',
	'async',
	'common',
	'423',
	'416',
	'417'
], function(jQuery, async, commonTests, appname, search, views ) {
	var $$ = jQuery.noConflict(true),
	myFrame = $$("#myFrame");

	var setup = function() {
		var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;
		defineTests();

		async.series([
			function(next) {
				$$(document).ready(function() { next(); });
			},
			function(next) {
				myFrame.attr('src', referencePath + '../../logout')
					.one('load', function() { next(); });
			},
			function(next) {
				myFrame.attr('src', referencePath + '../../oauthlogin?redirect_uri=' + referencePath + '../../customdataview')
					.one('load', function() { next(); });
			},
			function(next) {
				afterJqueryLoad(function () {
					//grab jQuery from inside the document
					$ = jQuery = myFrame[0].contentWindow.jQuery;

					$("#name-c").val( 'zztest.staff01' );
					$("#password").val('pass');
					$("#facilityName").val('DC VAMC');
					$("#facilityCode").val('688');

					$("#logonForm").submit();
					myFrame.one('load', function() {
						afterJqueryLoad(function () {
							afterOauthTokenInSessionStorage(function() {
								next();
							});
						});
					});
				});
			}
		], function() {
			start();
		});

		QUnit.testStart(function() {
			stop();
			myFrame.off("load");
			myFrame.attr('src', referencePath + '../../customdataview')
				.on("load", function() {
					afterJqueryLoad(function() {
						var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;
						
						//grab jQuery from inside the document
						$ = jQuery = myFrame[0].contentWindow.jQuery;

						//turn off async so tests will wait for ajax results
						$.ajaxSetup({ async: false });

						$.getScript(referencePath + "../jquery.simulate.js");

						//turn off animations so they do not break tests
						$.support.cssTransitions = false;
						$.fx.off = true;
						
						var started = false;
						$(myFrame[0].contentWindow.document).ready(function () {
							setTimeout(function() {
								if (!started) {
									started = true;
									QUnit.start();
								}
								
							}, 1000);
						});
						
						setTimeout(function() {
							if (!started) {
								started = true;
								QUnit.start();
							}
						}, 5000);
					});
				});
		});

	};
	
	function afterJqueryLoad(callback) {
		if (typeof myFrame[0].contentWindow.jQuery === 'undefined') {
			setTimeout(function() {
				afterJqueryLoad(callback);
			}, 200);
		} else {
			callback();
		}
	}

	function afterOauthTokenInSessionStorage(callback) {
		var token = myFrame[0].contentWindow.sessionStorage.token;
		if (typeof token !== 'undefined' && token && token !== 'null') {
			callback();
		} else {
			setTimeout(function() {
				afterOauthTokenInSessionStorage(callback);
			}, 200);
		}
	}

	function defineTests() {
		search.initialize();
		appname.initialize();
		views.initialize();
	}

	return {
		initialize: setup
	};
});
