define([
	'jQuery'
], function($$) {
	var defineTests = function() {
		
		function setUp(val) {
			$resultsTable = $('#patientSearchTable');
			
			$searchInput = $('input[name="patient-search"]');
			$searchInput.val(val);
			var event = $.Event( "keypress" );
			event.keyCode = 13;	
			$searchInput.trigger(event);
		}
		
		console.log('start tests');
		
		module("#417 Provider-facing SED Data Views");
				
		asyncTest("#425 Tapping/selecting a Veteran name will show a list of available views for that Veteran", function(){
			expect(1);
			async.series([function(next){
				setUp('patient66');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next){
				$('#patient-search-results li:nth-child(2) a').trigger('tap');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next) {
				start();
				equal($('.content-primary .ui-btn-text').eq(1).text().trim(), 'MyStory', 'Available views are displayed');
			}]);
		});
		
		asyncTest("#426 Tapping/selecting the name of a view will open the view of data in a read only manner", function(){
			expect(1);
			async.series([function(next){
				setUp('patient66');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next){
				$('#patient-search-results li:nth-child(2) a').trigger('tap');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next) {
				$('.content-primary a:eq(1)').trigger('tap');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next) {
				start();
				equal($('.content-primary h3').text().trim(), 'MyStory Summary', "The MYStory Summary Page is displayed");
			}]);
		});
				
		asyncTest("#427 User can navigate back to the list of possible views/search screen", function(){
			expect(1);
			async.series([function(next){
				setUp('patient66');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next){
				$('#patient-search-results li:nth-child(2) a').trigger('tap');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next) {
				$('.content-primary a:eq(1)').trigger('tap');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next) {
				$('.content-primary a.go-back').trigger('tap');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next) {
				start();
				equal($('.content-primary .ui-btn-text').eq(1).text().trim(), 'MyStory', 'Navigate back to Available Views');
			}]);
		});
		
		asyncTest("#467 If no data is available for a selected patient/view combination, 'No data found' is displayed", function(){
			expect(1);
			async.series([function(next){
				setUp('patient26');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next){
				$('#patient-search-results li:nth-child(3) a').trigger('tap');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next) {
				$('.content-primary a:eq(1)').trigger('tap');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next) {
				start();
				equal($('.content-primary p').text().trim(), 'No data found.', 'No data found displayed');
			}]);
		});
		
		asyncTest("#539 The user should see data elements in addition to the patient's view of the Health Inventory Summary, including the last four digits of the SSN and the DOB", function(){
			expect(4);
			async.series([function(next){
				setUp('patient66');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next){
				$('#patient-search-results li:nth-child(2) a').trigger('tap');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next) {
				$('.content-primary a:eq(1)').trigger('tap');
				setTimeout(function(){
					next(null);
				}, 1000 );
			},
			function(next) {
				start();
				ok($('#main ul li').eq(0).text().indexOf('Patient Name') > -1, 'Patient Name found');
				ok($('#main ul li').eq(1).text().indexOf('Date Of Birth') > -1, 'Date Of Birth found');
				ok($('#main ul li').eq(2).text().indexOf('Last4 SSN') > -1, 'Last4 SSN found');
				ok($('#main ul li').eq(3).text().indexOf('Summary Generated') > -1, 'Summary Generated found');
			}]);
		});
	};
	return {
		initialize: defineTests
	};
});
