define([
	'jQuery',
	'../helpers'
], function($$, helpers) {
	var defineTests = function() {
		console.log('start tests');
		
		module("#416 Patient Search for SED");
	
		function getResultsCount()
		{
			return $('#patient-search-results li a').length;	
		}
		
		function getName()
		{
			return $('#patient-search-results li:nth-child(2) a h3').eq(0).text();
		}		
		
		test("#419 User can enter a patient name or SSN to conduct patient search", function(){
			stop();
			async.series([function(next) {
				var $searchInput = $('input[name="patient-search"]');
				ok($searchInput.is(':visible') ,'Search input box exists');

				$searchInput.val('patient66');
				var event = $.Event( "keypress" );
					event.keyCode = 13;	
				$searchInput.trigger(event);
				next();
			}, function(next) {
				setTimeout(function() {
					ok($('#patient-search-results li').length >= 1, 'There are matching records for name patient66. If this test fails, make sure this patient exists.');
					next();
				}, 100);
			}], start);
		});
		
		test("#420 If no match is found, 'There are no matching records.' is displayed", function () {
			stop();
			
			async.series([function(next) {
				var $searchInput = $('input[name="patient-search"]');
				$searchInput.val('zzzzzzzzzzzz');
				var event = $.Event( "keypress" );
				event.keyCode = 13;	
				$searchInput.trigger(event);
				next();
			}, function(next) {
				setTimeout(function() {
					var resultLength = getResultsCount();
					equal(resultLength, 0, 'Verify that no rows are displayed');
					equal($('#displayed-result-count').text(), 'Displaying 0 results',
							'Verify the correct count of records is displayed');
					
					next();
				}, 100);
			}], start);
			
		});

	};
	return {
		initialize: defineTests
	};
});
