define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
	var openAbout = function() {
		// click the About Women Veterans button
		ok($( "#aboutWomenVeterans" ).simulate("click"), "When I click the About Women Veterans button");
	};
	
	var openCommonVeteranIssues = function() {
		// click the About Women Veterans button
		ok($( "#commonHealthIssues" ).simulate("click"), "When I click the common veteran Issues button");
	};

	var isOnAboutPage = function () {
		// About Women Veterans header is visible
		ok($( 'h1:contains("About")' ).is(":visible"), "About Women Veterans header is visible");
	};
	var isOnCommonHealthIssuesPage = function () {
		// About Women Veterans header is visible
		ok($( 'h1:contains("Issues")' ).is(":visible"), "Common Veteran Issues header is visible");
	};
	
	var backButtonAndFooterArePresent = function () {
		// make sure the Back button is visible
		ok($(".ui-btn-text:contains('Back')").is(":visible"), "Back button is visible");
		
		var $footer = $("div[data-role='footer']");
		
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		
		// make sure all footer links are present
		ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
		ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
		ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
		ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
	};
	
	var clickBack=function () {
		// click the Back button
		ok($( ".ui-btn-text:contains('Back')" ).simulate("click"), "When I click the Back button");
	};
	return {
		openAbout: openAbout,
		openCommonVeteranIssues: openCommonVeteranIssues,
		isOnAboutPage:isOnAboutPage,
		isOnCommonHealthIssuesPage : isOnCommonHealthIssuesPage,
		backButtonAndFooterArePresent: backButtonAndFooterArePresent,
		clickBack: clickBack
	};
});

