define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {

		module("#517 Find a VA");
		
		//***** FUNCTIONS ******//
		
		function isOnHomePage() {
			// Caring4WomenVeterans header is visible
			ok($( 'h1:contains("Caring")' ).is(":visible"), "Caring4WomenVeterans header is visible");
			// Find a VA button is visible
			ok($( "a:contains('Find')" ).is(":visible"), " Find a VA button is visible");
		}
				
		function isOnFindAVaPage() {
			// Find a VA  header is visible
			ok($( "h1:contains('Find')" ).is(":visible") , " Find a VA header is visible");
		}
		
		function backFooterIsPresent() {
			// make sure the Back button is visible
			ok($( "a[data-rel='back']" ).is(":visible"), "Back button is visible");
			
			var $footer = $("div[data-role='footer']");
			
			// make sure the footer is visible
			ok($footer.is(":visible"), "Footer is visible");
			
			// make sure all footer links are present
			ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
			ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
			ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
			ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
		}
		
		function clickBack() {
			// click the Back button
			ok($( "a[data-rel='back']" ).simulate("click"), "When I click the Back button");
		}
		
		

		//***** TESTS *****//
		
		test("Navigate to Find a VA and check page content", function() {
			stop();
			asyncSeries(
				function(){
					return 150;
				},
				isOnHomePage,
				function() {
					// starting on main page
					ok($(".ui-btn-text:contains('Find a VA')").is(":visible"), "Find a VA button is visible");
					ok($(".ui-btn-text:contains('Find a VA')").simulate("click"), "When I click the Find a VA button");
				}, 
				isOnFindAVaPage,
				function () {
					ok($('.ui-btn-text:contains("Health Centers by Region")').is(':visible'), 'Health Centers by Region link visible');
					ok($('.ui-btn-text:contains("Facilities by State")').is(':visible'), 'Facilities by State link visible');
					ok($('.ui-btn-text:contains("Facilities by Zip Code")').is(':visible'), 'Facilities by Zip Code link visible');
				},
				function () {
					// Select location type
					ok($(".ui-btn-text:contains('Health Centers by Region')" ).simulate("click"), 
					"When I click the Health Centers by Region button");
				},
				function(){
					// Select location link
					ok($("a[href*='www2.domain']").is(":visible"), "Find a domain link");
					ok($("a[href*='www2.domain']").simulate("click"), "When I click the www2.gov link");
				},
				function(){
					// Check for Leaving the Site popup warning
					ok($( "div[data-role='popup']" ).is(":visible"), "Leaving the Site popup is visible");
					// Cancel out of popup and remain on page
					ok($('.ui-btn-text:contains("Cancel")').is(':visible'), 'Leaving the Site Cancel button is visible');
					ok($('.ui-btn-text:contains("Cancel")').click(), "When I click the Leaving the Site Cancel button");
				},
				isOnFindAVaPage,
				backFooterIsPresent,
				clickBack, 
				isOnHomePage,
				start
			);
		});
	});