define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {

		module("#516 Resources scction");
		
		//***** FUNCTIONS ******//
		
		function isOnHomePage() {
			// Caring4WomenVeterans header is visible
			ok($( 'h1:contains("Caring")' ).is(":visible"), "Caring4WomenVeterans header is visible");
			// Find a VA button is visible
			ok($( "a:contains('Resources')" ).is(":visible"), "Resources button is visible");
		}
				
		function isOnResourcesPage() {
			// Resources header is visible
			ok($( "h1:contains('Resources')" ).is(":visible") , "Resources is visible");
		}
		
		function isOnVASupportPage() {
			ok($( 'h1:contains("VA Support")' ).is(":visible"), "VA Support header is visible");
		}
		function backFooterIsPresent() {
			// make sure the Back button is visible
			ok($( "a[data-rel='back']" ).is(":visible"), "Back button is visible");
			
			var $footer = $("div[data-role='footer']");
			
			// make sure the footer is visible
			ok($footer.is(":visible"), "Footer is visible");
			
			// make sure all footer links are present
			ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
			ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
			ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
			ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
		}
		
		function clickBack() {
			// click the Back button
			ok($( "a[data-rel='back']" ).simulate("click"), "When I click the Back button");
		}
		
		

		//***** TESTS *****//
		
		test("Navigate to Resources and check page contents", function() {
			stop();
			asyncSeries(
				function(){
					return 150;
				},
				isOnHomePage,
				function() {
					// starting on main page
					ok($(".ui-btn-text:contains('Resources')").is(":visible"), "Resources button is visible");
					ok($(".ui-btn-text:contains('Resources')").simulate("click"), "When I click the Resources button");
				}, 
				isOnResourcesPage,
				backFooterIsPresent,
				function () {
					//navigating to Resources main page and checking page content
					ok($( 'h3:contains("Benefits & Eligibility")' ).is(":visible"), "Benefits & Eligibility button is visible");
					ok($( 'h3:contains("VA Medical Center")' ).is(":visible"), "VA Medical Center button is visible");
					ok($( 'h3:contains("VA Health Care Support")' ).is(":visible"), "VA Health Care Support button is visible");
				},
				backFooterIsPresent,
				function () {
					// click Benefits & Eligibility button and check page content
					ok($( 'h3:contains("Benefits & Eligibility")' ).simulate("click"), "When I click the Benefits & Eligibility button");
                },
                function () {
					ok($( 'h1:contains("Benefits & Eligibility")' ).is(":visible"), "Benefits & Eligibility header is visible");
					ok($(".ui-btn-text:contains('Disability and Compensation')").is(":visible"), "Disability and Compensation button is visible");
				},
				backFooterIsPresent,
				clickBack,

				function () {
					// click VA Medical Center button and check page contents
					ok($( 'h3:contains("VA Medical Center")' ).simulate("click"), "When I click the VA Medical Center button");
                },
                function () {
					ok($( 'h1:contains("VA Facility Locator")' ).is(":visible"), "VA Facility Locator header is visible");
					ok($(".ui-btn-text:contains('VA Facility Locator')").is(":visible"), "VA Facility Locator button is visible");
					},
					backFooterIsPresent,
					clickBack,
				function () {
					// Naviget to VA support page
					ok($( 'h3:contains("VA Health Care Support")' ).simulate("click"), "When I click the VA Health Care Support button");
					ok($( 'h1:contains("VA Support")').is(":visible"), "VA Support header is visible");
					//navigate to Coaching into Care page
                    ok($( 'a:contains("Coaching into Care")').is(":visible"), "Coaching into Care button is visible");
                    ok($( 'a:contains("Coaching into Care")').simulate("click"), "When I click the Coaching into Care button");
                },
                function () {
                    ok($( 'h1:contains("Coaching into Care")').is(":visible"), "Coaching into Care headers visible");
                    ok($(".ui-btn-text:contains('Coaching into Care')").is(":visible"), "Coaching into Care button is visible");
                },
                backFooterIsPresent,
				clickBack,
                isOnVASupportPage,
                function () {
                     //navigate to Homeless Veterans page
                     ok($( 'a:contains("Homeless Veterans")').is(":visible"), "Homeless Veterans button is visible");
                     ok($( 'a:contains("Homeless Veterans")').simulate("click"), "When I click the Homeless Veterans button");
                     return 200;
                },
                function () {
                     ok($( 'h1:contains("Homeless Veterans")').is(":visible") , "Homeless Veterans header is visible");
                     ok($(".ui-btn-text:contains('Homeless Veterans Webpage')").is(":visible"), "Homeless Veterans Webpage button is visible");                    
                },
                backFooterIsPresent,
				clickBack,
                isOnVASupportPage,	
                function () {
                    //navigate to Mental Health page
                    ok($( 'a:contains("Mental Health")').is(":visible"), "Mental Health button is visible");
                    ok($( 'a:contains("Mental Health")').simulate("click"), "When I click the Mental Health button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("Mental Health Website")').is(":visible") , "Mental Health Website header is visible");
                    ok($(".ui-btn-text:contains('Community Providers Page')").is(":visible"), "Community Providers Page button is visible");
               },
//                backFooterIsPresent,
				clickBack,
				isOnVASupportPage,	
				function () {
                    //navigate to Military Sexual Trauma page
                    ok($( 'a:contains("Military Sexual Trauma")').is(":visible"), "Military Sexual Trauma button is visible");
                    ok($( 'a:contains("Military Sexual Trauma")').simulate("click"), "When I click the Military Sexual Trauma button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("MST")').is(":visible") , "MST header is visible");
                    ok($(".ui-btn-text:contains('Military Sexual Trauma')").is(":visible"), "Military Sexual Trauma button is visible");
               },
                backFooterIsPresent,
				clickBack,
				isOnVASupportPage,
				function () {
                    //navigate to National Center for PTSD page
                    ok($( 'a:contains("National Center for PTSD")').is(":visible"), "National Center for PTSD button is visible");
                    ok($( 'a:contains("National Center for PTSD")').simulate("click"), "When I click the National Center for PTSD button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("National Center for PTSD")').is(":visible") , "National Center for PTSD header is visible");
                    ok($(".ui-btn-text:contains('VA PTSD Program Locator')").is(":visible"), "VA PTSD Program Locator button is visible");
               },
                backFooterIsPresent,
				clickBack,
				isOnVASupportPage,
				function () {
                    //navigate to Returning OEF/OIF/OND (Iraq/Afghanistan) Veterans page
                    ok($( 'a:contains("Returning OEF")').is(":visible"), "Returning OEF button is visible");
                    ok($( 'a:contains("Returning OEF")').simulate("click"), "When I click the Returning OEF button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("Returning OEF/OIF/OND (Iraq/Afghanistan) Veterans")').is(":visible") , "Returning OEF header is visible");
                    ok($(".ui-btn-text:contains('Returning OEF/OIF Veteran website')").is(":visible"), "Returning OEF/OIF Veteran website button is visible");
               },
                backFooterIsPresent,
				clickBack,
				isOnVASupportPage,
				function () {
                    //navigate to Traumatic Brain Injury (TBI) page
                    ok($( 'a:contains("Traumatic Brain Injury (TBI)")').is(":visible"), "TBI button is visible");
                    ok($( 'a:contains("Traumatic Brain Injury (TBI)")').simulate("click"), "When I click the TBI button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("Traumatic Brain Injury (TBI)")').is(":visible") , "TBI header is visible");
                    ok($(".ui-btn-text:contains('Polytrauma System of Care Facilities')").is(":visible"), "Polytrauma System of Care Facilities button is visible");
               },
                backFooterIsPresent,
				clickBack,
				isOnVASupportPage,
				function () {
                    //navigate to VA Center for Women Veterans page
                    ok($( 'a:contains("VA Center for Women Veterans")').is(":visible"), "VA Center for Women Veterans button is visible");
                    ok($( 'a:contains("VA Center for Women Veterans")').simulate("click"), "When I click the VA Center for Women Veterans button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("VA Center for Women Veterans")').is(":visible") , "VA Center for Women Veterans header is visible");
                    ok($(".ui-btn-text:contains('VA Center for Women Veterans')").is(":visible"), "VA Center for Women Veterans button is visible");
               },
               backFooterIsPresent,
               clickBack,
				isOnVASupportPage,
				function () {
                    //navigate to VA Public Health page
                    ok($( 'a:contains("VA Public Health")').is(":visible"), "VA Public Health button is visible");
                    ok($( 'a:contains("VA Public Health")').simulate("click"), "When I click the VA Public Health button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("VA Public Health")').is(":visible") , "VA Public Health header is visible");
                    ok($(".ui-btn-text:contains('Environmental Health Coordinators')").is(":visible"), "Environmental Health Coordinators button is visible");
               },
               backFooterIsPresent,
               clickBack,
               isOnVASupportPage,
				function () {
                    //navigate to VA War Related Illness page
                    ok($( 'a:contains("VA War Related Illness")').is(":visible"), "VA War Related Illness button is visible");
                    ok($( 'a:contains("VA War Related Illness")').simulate("click"), "When I click the VA War Related Illness button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("VA War Related Illness & Injury Study Center (WRIISC)")').is(":visible") , "VA War Related Illness header is visible");
                    ok($(".ui-btn-text:contains('Education Section')").is(":visible"), "Education Section button is visible");
               },
               backFooterIsPresent,
               clickBack,
               isOnVASupportPage,
				function () {
                    //navigate to Vet Centers page
                    ok($( 'a:contains("Vet Centers")').is(":visible"), "Vet Centers button is visible");
                    ok($( 'a:contains("Vet Centers")').simulate("click"), "When I click the Vet Centers button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("Vet Centers")').is(":visible") , "Vet Centers header is visible");
                    ok($(".ui-btn-text:contains('Community based centers')").is(":visible"), "Community based centers button is visible");
               },
               backFooterIsPresent,
               clickBack,
               isOnVASupportPage,
				function () {
                    //navigate to Veterans Crisis Line page
                    ok($( 'a:contains("Veterans Crisis Line")').is(":visible"), "Veterans Crisis Line button is visible");
                    ok($( 'a:contains("Veterans Crisis Line")').simulate("click"), "When I click the Veterans Crisis Line button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("Veterans Crisis Line")').is(":visible") , "Veterans Crisis Line header is visible");
                    ok($(".ui-btn-text:contains('Veterans Crisis Line')").is(":visible"), "Veterans Crisis Line button is visible");
               },
               backFooterIsPresent,
               clickBack,
               isOnVASupportPage,
				function () {
                    //navigate to Women's Health Services page
                    ok($( 'a:contains("Health Services")').is(":visible"), "Health Services button is visible");
                    ok($( 'a:contains("Health Services")').simulate("click"), "When I click the Health Services button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("Health Services")').is(":visible") , "Health Services header is visible");
                    ok($(".ui-btn-text:contains('Health Services')").is(":visible"), "Health Services button is visible");
               },
               backFooterIsPresent,
               clickBack,
               isOnVASupportPage,
				function () {
                    //navigate to Women Veterans Call Center page
                    ok($( 'a:contains("Women Veterans Call Center")').is(":visible"), "Women Veterans Call Center button is visible");
                    ok($( 'a:contains("Women Veterans Call Center")').simulate("click"), "When I click the Women Veterans Call Center button");
                    return 200;
               },
               function () {
                    ok($( 'h1:contains("Women Veterans Call Center")').is(":visible") , "Women Veterans Call Center header is visible");
                    ok($(".ui-btn-text:contains('1-855-829-6636')").is(":visible"), "1-855-VA-WOMEN button is visible");
               },
               backFooterIsPresent,
               clickBack,
               isOnVASupportPage,
                start
				);
			});
		});