define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		
	module("#515 Reintegration Issues");
	
	//***** FUNCTIONS ******//
	
	function goToReintegrationMainPage() {
		isOnHomePage();
		openReintegrationMain();
		isOnReintegrationMainPage();
	}
	
	// using this combined function breaks the tests for some reason - ACJ
	// function checkFooterAndReturnToReintegrationMain() {
		// backButtonAndFooterArePresent();
		// clickBack();
		// isOnReintegrationMainPage();
	// }
	
	function isOnHomePage() {
		// Caring4WomenVeterans header is visible
		ok($( 'h1:contains("Caring")' ).is(":visible"), "Caring4WomenVeterans header is visible");
		// Reintegration Issues button is visible
		ok($( "#reintegrationIssues" ).is(":visible"), "Reintegration Issues button is visible");
	}
			
	function openReintegrationMain() {
		// click the Reintegration Issues button
		ok($( "#reintegrationIssues" ).simulate("click"), "When I click the Reintegration Issues button");
	}
	
	function isOnReintegrationMainPage() {
		// Reintegration Issues header is visible
		ok($( 'h1:contains("Reintegration Issues")' ).is(":visible"), "Reintegration Issues header is visible");
		// Reintegration into Civilian Life button is visible
		ok($( "#reintegrationIntoCivilianLife" ).is(":visible"), "Reintegration into Civilian Life button is visible"); 
		// Employment and Finances button is visible
		ok($( "#employmentAndFinances" ).is(":visible"), "Employment and Finances button is visible"); 
		// Homelessness button is visible
		ok($( "#homelessness" ).is(":visible"), "Homelessness button is visible"); 
	}
	
	function backButtonAndFooterArePresent() {
		// make sure the Back button is visible
		ok($( "a[data-rel='back']" ).is(":visible"), "Back button is visible");
		
		var $footer = $("div[data-role='footer']");
		
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		
		// make sure all footer links are present
		ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
		ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
		ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
		ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
	}
	
	function clickBack() {
		// click the Back button
		ok($( "a[data-rel='back']" ).simulate("click"), "When I click the Back button");
	}
	
	function openReintegrationSubPage() {
		// click the Reintegration into Civilian Life button
		ok($("#reintegrationIntoCivilianLife").simulate("click"), "When I click the Reintegration into Civilian Life button");
	}
	
	function openEmploymentPage() {
		// click the Employment and Finances button
		ok($("#employmentAndFinances").simulate("click"), "When I click the Employment and Finances button");
	}
	
	function openHomelessnessPage() {
		// click the Homelessness button
		ok($("#homelessness").simulate("click"), "When I click the Homelessness button");
	}

	//***** TESTS *****//
	
	test("Navigate to Reintegration Issues and check page content", function() {
		stop();
		asyncSeries(
			goToReintegrationMainPage,
			backButtonAndFooterArePresent,
			clickBack, 
			isOnHomePage,
			start
		);
	});
		
	test("Navigate to Reintegration into Civilian Life and check page content", function() {
		stop();
		asyncSeries(
			goToReintegrationMainPage,
			openReintegrationSubPage, 
			function () {
				// now on Reintegration into Civilian Life page
				ok($( 'h1:contains("Reintegration into Civilian Life")' ).is(":visible"), "Reintegration into Civilian Life header is visible");
				// VBA content is present
				ok($( 'li:contains("VBA")' ).is(":visible"), "VBA content is visible");			
			}, 
			backButtonAndFooterArePresent,
			clickBack, 
			isOnReintegrationMainPage,
			start
		);
	});
		
	test("Navigate to Services, Benefits, and Opportunities page and check page content", function() {
		stop();
		asyncSeries(
			goToReintegrationMainPage,
			openEmploymentPage,
			function () {
				// now on Services, Benefits, and Opportunities page
				ok($( 'h1:contains("Services")' ).is(":visible"), "Services, Benefits, and Opportunities header is visible");
				// VBA content is present
				ok($( 'li:contains("VBA")' ).is(":visible"), "VBA content is visible");
			},
			backButtonAndFooterArePresent,
			clickBack, 
			isOnReintegrationMainPage,
			start
		);
	});
		
	test("Navigate to Homelessness and check page content", function() {
		stop();
		asyncSeries(
			goToReintegrationMainPage,
			openHomelessnessPage,
			function () {
				// now on Homelessness page
				ok($( 'h1:contains("Homelessness")' ).is(":visible"), "Homelessness header is visible");
				// VBA content is present
				ok($( 'li:contains("homeless")' ).is(":visible"), "Homelessness content is visible");	
			},
			backButtonAndFooterArePresent,
			clickBack, 
			isOnReintegrationMainPage,
			start
		);
	});
});