define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
	
	module("#514 Military Sexual Trauma");
	
	//***** FUNCTIONS ******//
	
	
	function openMst() {
		// click the Military Sexual Trauma button
		ok($( "#mst" ).simulate("click"), "When I click the Military Sexual Trauma button");
	}
	
	function isOnMstPage() {
		ok($('h1:contains("Military Sexual Trauma")' ).is(":visible"), "Military Sexual Trauma is visible");
		ok($('#mstWhatIsMst').is(':visible'), 'What is MST link visible');
		ok($('#mstWhatCanProvidersDo').is(':visible'), 'What Can Providers Do link visible');
	}
	
	function openWhatIsMst() {
		// click the What IS MST button
		ok($( "#mstWhatIsMst" ).simulate("click"), "When I click the What is MST button");
	}
	
	function isOnWhatIsMstPage() {
		// What is MST header is visible
		ok($('h1:contains("What Is MST")' ).is(":visible"), "What Is MST is visible");
	}
	
	function openWhatCanProvidersDo() {
		// click the What Can Providers Do button
		ok($( "#mstWhatCanProvidersDo" ).simulate("click"), "When I click the What Can Providers Do button");
	}
	
	function isOnWhatCanProvidersDoPage() {
		// What Can Providers Do header is visible
		ok($('h1:contains("What Can Providers Do")' ).is(":visible"), "What Can Providers Do is visible");
	}
	
	function isOnHomePage() {
		// Caring4WomenVeterans header is visible
		ok($( 'h1:contains("Caring4WomenVeterans")' ).is(":visible"), "Caring4WomenVeterans header is visible");
		ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
	}
	
	function backButtonAndFooterArePresent() {
		// make sure the Back button is visible
		ok($(".ui-btn-text:contains('Back')").is(":visible"), "Back button is visible");
		
		var $footer = $("div[data-role='footer']");
		
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		
		// make sure all footer links are present
		ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
		ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
		ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
		ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
	}
	
	function clickBack() {
		// click the Back button
		ok($( ".ui-btn-text:contains('Back')" ).simulate("click"), "When I click the Back button");
	}
	
	test("Navigate to MST pages and check page content", function() {
		stop();
		asyncSeries(
			function() {
				// starting on main page
				ok($( "#commonHealthIssues" ).is(":visible"), "Common Veteran Issues button is visible");
			}, 
			// Navigate to the Common Veteran Issues Page
			function(){
				ok($( "#commonHealthIssues" ).simulate("click"), "When I click the Common Veteran Issues button");
				ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
			},
			openMst,
			isOnMstPage,
			openWhatIsMst,
			isOnWhatIsMstPage,
			backButtonAndFooterArePresent,
			clickBack,
			isOnMstPage,
			openWhatCanProvidersDo,
			isOnWhatCanProvidersDoPage,
			backButtonAndFooterArePresent,
			clickBack,
			isOnMstPage,
			start
		);
	});
});
