define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		
	module("#513 PTSD");
	
	//***** FUNCTIONS ******//
	
	function goToCommonVeteranIssuesPage() {
		isOnHomePage();
		openCommonVeteranIssues();
		isOnCommonVeteranIssuesPage();
	}
	
	// using this combined function breaks the tests - Amanda
	// function goToPtsdPage() {
		// goToCommonVeteranIssuesPage();
		// openPtsdPage();
		// isOnPtsdPage();
	// }
	
	function isOnPtsdPage() {
		// now on PTSD page
		ok($( 'h1:contains("PTSD")' ).is(":visible"), "PTSD header is visible");
		// "What Is PTSD" link is present
		ok($("a:contains('What Is PTSD')").is(":visible"), "What Is PTSD link is visible");	
		// "How Many" link is present
		ok($("a:contains('How Many')").is(":visible"), "How Many PTSD link is visible");
		// "Non-VA" link is present
		ok($( 'a:contains("Non-VA")' ).is(":visible"), "Non-VA link is visible");
		// "Screening Questions" link is present
		ok($( 'a:contains("Screening Questions")' ).is(":visible"), "Screening Questions link is visible");
		// "What If" link is present
		ok($( 'a:contains("What If")' ).is(":visible"), "What If PTSD link is visible");
	}
	
	function isOnHomePage() {
		// Caring4WomenVeterans header is visible
		ok($( 'h1:contains("Caring")' ).is(":visible"), "Caring4WomenVeterans header is visible");
		// Common Veteran Issues button is visible
		ok($( "#commonHealthIssues" ).is(":visible"), "Common Veteran Issues button is visible");
	}
			
	function openCommonVeteranIssues() {
		// click the Common Veteran Issues button
		ok($( "#commonHealthIssues" ).simulate("click"), "When I click the Common Veteran Issues button");
	}
	
	function isOnCommonVeteranIssuesPage() {
		// Common Veteran Issues header is visible
		ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues header is visible");
		// PTSD button is visible
		ok($( "#ptsd" ).is(":visible"), "PTSD button is visible"); 
	}
	
	function backButtonAndFooterArePresent() {
		// make sure the Back button is visible
		ok($( "a[data-rel='back']" ).is(":visible"), "Back button is visible");
		
		var $footer = $("div[data-role='footer']");
		
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		
		// make sure all footer links are present
		ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
		ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
		ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
		ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
	}
	
	function clickBack() {
		// click the Back button
		ok($( "a[data-rel='back']" ).simulate("click"), "When I click the Back button");
	}
	
	function openPtsdPage() {
		// click the PTSD button
		ok($("#ptsd").simulate("click"), "When I click the PTSD button");
	}
	
	function openWhatIsPtsdPage() {
		// click the What Is PTSD link
		ok($("a:contains('What Is PTSD')").simulate("click"), "When I click the What Is PTSD link");
	}
	
	function openHowManyPtsdPage() {
		// click the How Many PTSD link
		ok($("a:contains('How Many')").simulate("click"), "When I click the How Many PTSD link");
	}
	
	function openNonVAPtsdPage() {
		// click the Non-VA PTSD link
		ok($("a:contains('Non-VA')").simulate("click"), "When I click the Non-VA PTSD link");
	}
	
	function openScreeningQuestionsPtsdPage() {
		// click the Screening Questions PTSD link
		ok($("a:contains('Screening Questions')").simulate("click"), "When I click the Screening Questions PTSD link");
	}
	
	function openWhatIfPtsdPage() {
		// click the What If PTSD link
		ok($("a:contains('What If')").simulate("click"), "When I click the What If PTSD link");
	}

	//***** TESTS *****//
	
	test("Navigate to Common Veteran Issues and check page content", function() {
		stop();
		asyncSeries(
			goToCommonVeteranIssuesPage,
			backButtonAndFooterArePresent,
			clickBack, 
			isOnHomePage,
			start
		);
	});
		
	test("Navigate to PTSD and check page content", function() {
		stop();
		asyncSeries(
			goToCommonVeteranIssuesPage,
			openPtsdPage,
			isOnPtsdPage, 
			backButtonAndFooterArePresent,
			clickBack, 
			isOnCommonVeteranIssuesPage,
			start
		);
	});
	
	test("Navigate to What Is PTSD and check page content", function() {
		stop();
		asyncSeries(
			goToCommonVeteranIssuesPage,
			openPtsdPage,
			isOnPtsdPage,
			openWhatIsPtsdPage,
			function() {
				// What Is PTSD header is visible
				ok($( 'h1:contains("What Is PTSD")' ).is(":visible"), "What Is PTSD header is visible");
				// What Is PTSD content is visible
				ok($( "li:contains('Symptoms of PTSD include')" ).is(":visible"), "What Is PTSD content is visible");
			},
			backButtonAndFooterArePresent,
			clickBack, 
			isOnPtsdPage,
			start
		);
	});
	
	test("Navigate to How Many PTSD and check page content", function() {
		stop();
		asyncSeries(
			goToCommonVeteranIssuesPage,
			openPtsdPage,
			isOnPtsdPage,
			openHowManyPtsdPage,
			function() {
				// How Many PTSD header is visible
				ok($( 'h1:contains("How Many")' ).is(":visible"), "How Many PTSD header is visible");
				// How Many PTSD content is visible
				ok($( "li:contains('almost 20%')" ).is(":visible"), "How Many PTSD content is visible");
			},
			backButtonAndFooterArePresent,
			clickBack, 
			isOnPtsdPage,
			start
		);
	});
	
	test("Navigate to Screening Non-VA and check page content", function() {
		stop();
		asyncSeries(
			goToCommonVeteranIssuesPage,
			openPtsdPage,
			isOnPtsdPage,
			openNonVAPtsdPage,
			function() {
				// Non-VA header is visible
				ok($( 'h1:contains("Non-VA")' ).is(":visible"), "Non-VA header is visible");
				// Non-VA content is visible
				ok($( "li:contains('address a positive screen')" ).is(":visible"), "Non-VA content is visible");
			},
			backButtonAndFooterArePresent,
			clickBack, 
			isOnPtsdPage,
			start
		);
	});
	
	test("Navigate to Screening Questions and check page content", function() {
		stop();
		asyncSeries(
			goToCommonVeteranIssuesPage,
			openPtsdPage,
			isOnPtsdPage,
			openScreeningQuestionsPtsdPage,
			function() {
				// Screening Questions header is visible
				ok($( 'h1:contains("Screening Questions")' ).is(":visible"), "Screening Questions header is visible");
				// Screening Questions content is visible
				ok($( "li:contains('nightmares about it')" ).is(":visible"), "Screening Questions content is visible");
			},
			backButtonAndFooterArePresent,
			clickBack, 
			isOnPtsdPage,
			start
		);
	});
	
	test("Navigate to What If PTSD and check page content", function() {
		stop();
		asyncSeries(
			goToCommonVeteranIssuesPage,
			openPtsdPage,
			isOnPtsdPage,
			openWhatIfPtsdPage,
			function() {
				// What If PTSD header is visible
				ok($( 'h1:contains("What If")' ).is(":visible"), "What If header is visible");
				// What If PTSD content is visible
				ok($( "li:contains('CBT')" ).is(":visible"), "What If content is visible");
			},
			backButtonAndFooterArePresent,
			clickBack, 
			isOnPtsdPage,
			start
		);
	});
});