define([
	'jQuery',
	'Underscore',
	'asyncSeries',
	'commonFunctions'

], function($$, Underscore, asyncSeries, commonFunctions) {
	
	module("#512 Women Veterans and Suicide in Common Veteran Issues ");
	
	//***** FUNCTIONS ******//
	
	function openSuicide() {
		// click the Women Veterans and Suicide button
		ok($( "#suicide" ).simulate("click"), "When I click the Women Veterans and Suicide button");
	}
	
	function isOnSuicidePage() {
		ok($('h1:contains("Women Veterans and Suicide")' ).is(":visible"), "Women Veterans and Suicide is visible");
		ok($("a:contains('Women Veterans at High Risk')").is(":visible"), "Women Veterans at High Risk button is visible");
		ok($("a:contains('Veterans Crisis Line')").is(":visible"), "Veterans Crisis Line button is visible");
	}
	
	function openWomenVeteransAtHighRisk() {
		// click the Women Veterans at High Risk button
		ok($( "a:contains('Women Veterans at High Risk')" ).simulate("click"), "When I click the Women Veterans at High Risk button");
	}
	
	function isOnWomenVeteransAtHighRiskPage() {
		// At Women Veterans at High Risk header is visible
		ok($('h1:contains("Women Veterans at High Risk")' ).is(":visible"), "Women Veterans at High Risk is visible");
	}
	
	function openVeteransCrisisLine() {
		// click the Women Veterans Crisis Line button
		ok($( "a:contains('Veterans Crisis Line')" ).simulate("click"), "When I click the Women Veterans Crisis Line button");
	}
	
	function isOnVeteransCrisisLinePage() {
		// Veterans Crisis Line header is visible
		ok($('h1:contains("Veterans Crisis Line")' ).is(":visible"), "Veterans Crisis Line is visible");
	}
	
	function isOnHomePage() {
		// Caring4WomenVeterans header is visible
		ok($( 'h1:contains("Caring4WomenVeterans")' ).is(":visible"), "Caring4WomenVeterans header is visible");
		ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
	}
	
	function backButtonAndFooterArePresent() {
		// make sure the Back button is visible
		ok($(".ui-btn-text:contains('Back')").is(":visible"), "Back button is visible");
		
		var $footer = $("div[data-role='footer']");
		
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		
		// make sure all footer links are present
		ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
		ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
		ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
		ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
	}
	
	function clickBack() {
		// click the Back button
		ok($( ".ui-btn-text:contains('Back')" ).simulate("click"), "When I click the Back button");
	}
	
	test("Navigate to Suicide pages and check page content", function() {
		stop();
		asyncSeries(
			function() {
				// starting on main page
				ok($( "#commonHealthIssues" ).is(":visible"), "Common Veteran Issues button is visible");
			}, 
			// Navigate to the Common Veteran Issues Page
			function(){
				ok($( "#commonHealthIssues" ).simulate("click"), "When I click the Common Veteran Issues button");
				ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
			},
			openSuicide,
			isOnSuicidePage,
			openWomenVeteransAtHighRisk,
			isOnWomenVeteransAtHighRiskPage,
			backButtonAndFooterArePresent,
			clickBack,
			isOnSuicidePage,
			openVeteransCrisisLine,
			isOnVeteransCrisisLinePage,
			backButtonAndFooterArePresent,
			clickBack,
			isOnSuicidePage,
			start
		);
	});
});
