define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
	
	module("#507 What to Ask");
	
	//***** FUNCTIONS ******//
	
	function openWhatToAsk() {
		// click the About Women Veterans button
		ok($( "#whatToAsk" ).simulate("click"), "When I click the What To Ask button");
	}
	
	function isOnWhatToAskPage() {
		// What to Ask header is visible
		ok($( 'h1:contains("What To Ask")' ).is(":visible"), "What To Ask header is visible");
	}
	
	function isOnHomePage() {
		// Caring4WomenVeterans header is visible
		ok($( 'h1:contains("Caring4WomenVeterans")' ).is(":visible"), "Caring4WomenVeterans header is visible");
	}
	
	function backButtonAndFooterArePresent() {
		// make sure the Back button is visible
		ok($(".ui-btn-text:contains('Back')").is(":visible"), "Back button is visible");
		
		var $footer = $("div[data-role='footer']");
		
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		
		// make sure all footer links are present
		ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
		ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
		ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
		ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
	}
	
	function clickBack() {
		// click the Back button
		ok($( ".ui-btn-text:contains('Back')" ).simulate("click"), "When I click the Back button");
	}
	
	test("Navigate to What to Ask and check page content", function() {
		stop();
		asyncSeries(
			function() {
				// starting on main page
				ok($( "#whatToAsk" ).is(":visible"), "What to Ask button is visible");
			}, 
			openWhatToAsk, 
			isOnWhatToAskPage,
			function () {
				ok($('a:contains("Why Ask")').is(':visible'), 'Why Ask link visible');
				ok($('a:contains("What to Ask")').is(':visible'), 'What to Ask link visible');
			},
			backButtonAndFooterArePresent,
			clickBack, 
			isOnHomePage,
			start
		);
	});
});
