define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
	
	module("#506 Public Service Announcement");
	
	//***** FUNCTIONS ******//
	
	function openAbout() {
		// click the About Women Veterans button
		ok($( "#aboutWomenVeterans" ).simulate("click"), "When I click the About Women Veterans button");
	}
	
	function isOnAboutPage() {
		// About Women Veterans header is visible
		ok($( 'h1:contains("About")' ).is(":visible"), "About Women Veterans header is visible");
	}
	
	function backButtonAndFooterArePresent() {
		// make sure the Back button is visible
		ok($(".ui-btn-text:contains('Back')").is(":visible"), "Back button is visible");
		
		var $footer = $("div[data-role='footer']");
		
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		
		// make sure all footer links are present
		ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
		ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
		ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
		ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
	}
	
	function clickBack() {
		// click the Back button
		ok($( ".ui-btn-text:contains('Back')" ).simulate("click"), "When I click the Back button");
	}
	
	test("Navigate to Public Service Announcement and check page content", function() {
		stop();
		asyncSeries(
			function() {
				// starting on main page
				ok($( "#aboutWomenVeterans" ).is(":visible"), "About Women Veterans button is visible");
			}, 
			openAbout, 
			isOnAboutPage,
			function () {
				ok($( "#publicServiceAnnouncement" ).is(":visible"), "public Service Announcement button is visible");
				ok($( "#publicServiceAnnouncement" ).simulate("click"), "When I click the public Service Announcement button");
				// now on public Service Announcement page
				ok($( 'h1:contains("Public")' ).is(":visible"), "Facts header is visible");
			}, 
			backButtonAndFooterArePresent,
			clickBack, 
			isOnAboutPage,
			start
		);
	});
});
