define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		
	module("#504 Women Veteran Population Growth");
	
	//***** FUNCTIONS ******//
	
	function openAbout() {
		// click the About Women Veterans button
		ok($( "#aboutWomenVeterans" ).simulate("click"), "When I click the About Women Veterans button");
	}
	
	function isOnAboutPage() {
		// About Women Veterans header is visible
		ok($( 'h1:contains("About")' ).is(":visible"), "About Women Veterans header is visible");
		// Women Veteran Population Growth button is visible
		ok($( "#womenVeteranPopulationGrowth" ).is(":visible"), "Women Veteran Population Growth button is visible"); 
	}
	
	function openPopulation() {
		// click the Women Veteran Population Growth button
		ok($( "#womenVeteranPopulationGrowth" ).simulate("click"), "When I click the Women Veteran Population Growth button");
	}
	
	function backButtonAndFooterArePresent() {
		// make sure the Back button is visible
		ok($( "a[data-rel='back']" ).is(":visible"), "Back button is visible");
		
		var $footer = $("div[data-role='footer']");
		
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		
		// make sure all footer links are present
		ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
		ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
		ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
		ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
	}
	
	function clickBack() {
		// click the Back button
		ok($( "a[data-rel='back']" ).simulate("click"), "When I click the Back button");
	}

	//***** TESTS *****//
	
	test("Navigate to Population Growth and check page content", function() {
		stop();
		asyncSeries(
			function() {
				// starting on main page
				ok($( "#aboutWomenVeterans" ).is(":visible"), "About Women Veterans button is visible");
			}, 
			openAbout, 
			isOnAboutPage,
			openPopulation, 
			function () {
				// now on Women Veteran Population Growth page
				ok($( 'h1:contains("Population")' ).is(":visible"), "Population header is visible");
				// graph source is present
				ok($( 'p:contains("VetPOP")' ).is(":visible"), "Source attribution is visible");
				//check text update (story 1836)
				ok($( 'p:contains("Veterans Health Administration")' ).is(":visible"), "Source attribution is visible");
			}, 
			backButtonAndFooterArePresent,
			clickBack, 
			isOnAboutPage,
			start
		);
	});
});