define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {

		module("#501 Resources Section Hyperlinks");
		
		//***** FUNCTIONS ******//
		
		function isOnHomePage() {
			// Caring4WomenVeterans header is visible
			ok($( 'h1:contains("Caring")' ).is(":visible"), "Caring4WomenVeterans header is visible");
			// Find a VA button is visible
			ok($( "a:contains('Resources')" ).is(":visible"), "Resources button is visible");
		}
				
		function isOnResourcesPage() {
			// Resources header is visible
			ok($( "h1:contains('Resources')" ).is(":visible") , "Resources is visible");
		}
		
		function isOnVASupportPage() {
			ok($( 'h1:contains("VA Support")' ).is(":visible"), "VA Support header is visible");
		}
		function backFooterIsPresent() {
			// make sure the Back button is visible
			ok($( "a[data-rel='back']" ).is(":visible"), "Back button is visible");
			
			var $footer = $("div[data-role='footer']");
			
			// make sure the footer is visible
			ok($footer.is(":visible"), "Footer is visible");
			
			// make sure all footer links are present
			ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
			ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
			ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
			ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
		}
		
		function clickBack() {
			// click the Back button
			ok($( "a[data-rel='back']" ).simulate("click"), "When I click the Back button");
		}
		
		

		//***** TESTS *****//
		
		test("Navigate to Resources and check page contents", function() {
			stop();
			asyncSeries(
				function(){
					return 150;
				},
				isOnHomePage,
				function() {
					// starting on main page
					ok($(".ui-btn-text:contains('Resources')").is(":visible"), "Resources button is visible");
					ok($(".ui-btn-text:contains('Resources')").simulate("click"), "When I click the Resources button");
				}, 
				isOnResourcesPage,
				function () {
					//navigating to Resources main page and checking page content
					ok($( 'h3:contains("Benefits & Eligibility")' ).is(":visible"), "Benefits & Eligibility button is visible");
					ok($( 'h3:contains("VA Medical Center")' ).is(":visible"), "VA Medical Center button is visible");
					ok($( 'h3:contains("VA Health Care Support")' ).is(":visible"), "VA Health Care Support button is visible");
				},
				
				function () {
					// click Benefits & Eligibility button and check page content
					ok($( 'h3:contains("Benefits & Eligibility")' ).simulate("click"), "When I click the Benefits & Eligibility button");
                },
                function () {
					ok($( 'h1:contains("Benefits & Eligibility")' ).is(":visible"), "Benefits & Eligibility header is visible");
					ok($(".ui-btn-text:contains('Disability and Compensation')").is(":visible"), "Disability and Compensation button is visible");
				},
				function(){
					// Select location link
					ok($(".ui-btn-text:contains('Disability and Compensation')").simulate("click"), "When I click the Benefits & Eligibility button");

				},
				function(){
					// Check for Leaving the Site popup warning
					ok($( "div[data-role='popup']" ).is(":visible"), "Leaving the Site popup is visible");
					ok($('.ui-btn-text:contains("Yes")').is(':visible'), 'Leaving the Site Yes button is visible');
					ok($('.ui-btn-text:contains("Cancel")').is(':visible'), 'Leaving the Site Cancel button is visible');
					// Cancel out of popup and remain on page
					ok($('.ui-btn-text:contains("Cancel")').click(), "When I click the Leaving the Site Cancel button");
					return 200;
				},
                start
				);
			});
		});