define([
	'jQuery',
	'Underscore',
	'asyncSeries',
	'commonFunctions'

], function($$, Underscore, asyncSeries, commonFunctions) {

	
	module("#1131 Iraq and Afghanistan Wars");
	
	//***** FUNCTIONS ******//
	
	function openPhysicalHealthIssuesByEra() {
		// click the Physical Health Issues By Era button
		ok($( "#healthIssuesByEra" ).simulate("click"), "When I click the Physical Health Issues By Era button");
	}
	
	function isOnPhysicalHealthIssuesByEra() {
		ok($('h1:contains("Physical Health Issues By Era")' ).is(":visible"), "Physical Health Issues By Era is visible");
		ok($('h3:contains("Iraq War and Afghanistan War")').is(":visible"), "Iraq War and Afghanistan War button is visible");
	}
	
	function openIraqfWar() {
		// click the IraqWar button
		ok($( 'h3:contains("Iraq War and Afghanistan War")' ).simulate("click"), "When I click the Iraq War and Afghanistan War button");
		
	}
	
	function isOnIraqWarPage() {
		// Iraq and Afghanistan Wars header is visible, table is present and all buttons are visible
		ok($( 'h1:contains("Iraq and Afghanistan Wars")' ).is(":visible"), "Iraq and Afghanistan Wars is visible");
		ok($( 'td:contains("Diagnosis")' ).is(":visible"), "table is visible");
		ok($( 'a:contains("Musculoskeletal")' ).is(":visible"), "Musculoskeletal button is visible");
		ok($( 'a:contains("Traumatic Brain Injury")' ).is(":visible"), "Traumatic Brain Injury is visible");
		ok($( 'a:contains("Traumatic Amputation")' ).is(":visible"), "Traumatic Amputation button is visible");
		ok($( 'a:contains("Animal Bites/Rabies")' ).is(":visible"), "Animal Bites/Rabies button is visible");
		ok($( 'a:contains("Embedded Fragments")' ).is(":visible"), "Embedded Fragments button is visible");
		ok($( 'a:contains("Burn Pit Smoke")' ).is(":visible"), "Burn Pit Smoke button is visible");
		ok($( 'a:contains("Heat Injury")' ).is(":visible"), "Heat Injury button is visible");
		ok($( 'a:contains("Mefloquine (Lariam)")' ).is(":visible"), "Mefloquine (Lariam) button is visible");
		ok($( 'a:contains("Embedded Fragments (shrapnel)")' ).is(":visible"), "Embedded Fragments button is visible");
		ok($( 'a:contains("Infectious Disease")' ).is(":visible"), "Infectious Disease button is visible");
		ok($( 'a:contains("Burns")' ).is(":visible"), "Burns button is visible");
		ok($( 'a:contains("Depression")' ).is(":visible"), "Depression button is visible");
		ok($( 'a:contains("Hearing Loss")' ).is(":visible"), "Hearing Loss button is visible");
		ok($( 'a:contains("Reproductive Health")' ).is(":visible"), "Reproductive Health button is visible");
		ok($( 'a:contains("Genitourinary System")' ).is(":visible"), "Genitourinary System button is visible");
		ok($( 'a:contains("Digestive")' ).is(":visible"), "Digestive button is visible");
		
	}
	
	function isOnCommonVeteranIssuesPage() {
		// Common Veteran Issues header is visible
		ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues header is visible");
		
	}
	
	
	
	function isOnHomePage() {
		// Caring4WomenVeterans header is visible
		ok($( 'h1:contains("Caring4WomenVeterans")' ).is(":visible"), "Caring4WomenVeterans header is visible");
		ok($( 'a:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
	}
	
	function backButtonAndFooterArePresent() {
		// make sure the Back button is visible
		ok($(".ui-btn-text:contains('Back')").is(":visible"), "Back button is visible");
		
		var $footer = $("div[data-role='footer']");
		
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		
		// make sure all footer links are present
		ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
		ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
		ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
		ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
	}
	
	function clickBack() {
		// click the Back button
		ok($( ".ui-btn-text:contains('Back')" ).simulate("click"), "When I click the Back button");
	}

	// Navigate to the Common Veteran Issues Page
	function navCommonHealth() {
		// starting on main page
		ok($( "#commonHealthIssues" ).is(":visible"), "Common Veteran Issues button is visible");
		ok($( "#commonHealthIssues" ).simulate("click"), "When I click the Common Veteran Issues button");
		ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
	}
	test("Navigate to Health Issues By Era page and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			start
		);
	});
	test("Navigate to Musculoskeletal and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Musculoskeletal page
				ok($("a:contains('Musculoskeletal')" ).simulate("click"), "When I click the Musculoskeletal button");
				//check Injuries: Musculoskeletal header present
				ok($( 'h1:contains("Injuries: Musculoskeletal")' ).is(":visible"), "Injuries: Musculoskeletal header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	
	test("Navigate to Traumatic Brain Injury and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Traumatic Brain Injury page
				ok($("a:contains('Traumatic Brain Injury')" ).simulate("click"), "When I click the Traumatic Brain Injury button");
				//check TBI or Poli-trauma header present
				ok($( 'h1:contains("TBI or Poli-trauma")' ).is(":visible"), "TBI or Poli-trauma header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Traumatic Amputation and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Traumatic Amputation page
				ok($("a:contains('Traumatic Amputation')" ).simulate("click"), "When I click the Traumatic Amputation button");
				//check Traumatic Amputation header present
				ok($( 'h1:contains("Injuries: Traumatic Amputation")' ).is(":visible"), "Injuries: Traumatic Amputation header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Animal Bites/Rabies and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Animal Bites/Rabies page
				ok($("a:contains('Animal Bites/Rabies')" ).simulate("click"), "When I click the Animal Bites/Rabies button");
				//check Animal Bites/Rabies header present
				ok($( 'h1:contains("Exposures: Animal Bites/Rabies")' ).is(":visible"), "Animal Bites/Rabies header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Embedded Fragments and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Embedded Fragments page
				ok($("a:contains('Embedded Fragments')" ).simulate("click"), "When I click the Embedded Fragments button");
				//check Embedded Fragments header present
				ok($( 'h1:contains("Exposures: Embedded Fragments (Shrapnel)")' ).is(":visible"), "Embedded Fragments (Shrapnel) header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Burn Pit Smoke and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Burn Pit Smoke page
				ok($("a:contains('Burn Pit Smoke')" ).simulate("click"), "When I click the Burn Pit Smoke button");
				//check Burn Pit Smoke header present
				ok($( 'h1:contains("Exposures: Burn Pit Smoke")' ).is(":visible"), "Burn Pit Smoke header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Heat Injury and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Heat Injury page
				ok($("a:contains('Heat Injury')" ).simulate("click"), "When I click the Heat Injury button");
				//check Heat Injury header present
				ok($( 'h1:contains("Exposures: Heat Injury")' ).is(":visible"), "Heat Injury header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Mefloquine (Lariam) and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Mefloquine page
				ok($("a:contains('Mefloquine (Lariam)')" ).simulate("click"), "When I click the Mefloquine (Lariam) button");
				//check Mefloquine header present
				ok($( 'h1:contains("Exposures: Mefloquine")' ).is(":visible"), "Mefloquine header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Infectious Disease and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Infectious Disease page
				ok($("a:contains('Infectious Disease')" ).simulate("click"), "When I click the Infectious Disease button");
				//check Infectious Disease header present
				ok($( 'h1:contains("Infectious Diseases")' ).is(":visible"), "Infectious Diseases header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Burns and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Burns page
				ok($("a:contains('Burns')" ).simulate("click"), "When I click the Burns button");
				//check Burns header present
				ok($( 'h1:contains("Burns")' ).is(":visible"), "Burns header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Depression and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Depression page
				ok($("a:contains('Depression')" ).simulate("click"), "When I click the Depression button");
				//check Depression header present
				ok($( 'h1:contains("Depression")' ).is(":visible"), "Depression header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Hearing Loss and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Hearing Loss page
				ok($("a:contains('Hearing Loss')" ).simulate("click"), "When I click the Hearing Loss button");
				//check Hearing Loss header present
				ok($( 'h1:contains("Hearing Loss")' ).is(":visible"), "Hearing Loss header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Reproductive Health and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Reproductive Health page
				ok($("a:contains('Reproductive Health')" ).simulate("click"), "When I click the Reproductive Health button");
				//check Reproductive Health header present
				ok($( 'h1:contains("Reproductive Health")' ).is(":visible"), "Reproductive Health header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Genitourinary System and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Genitourinary System page
				ok($("a:contains('Genitourinary System')" ).simulate("click"), "When I click the Genitourinary System button");
				//check Genitourinary System header present
				ok($( 'h1:contains("Genitourinary System")' ).is(":visible"), "Genitourinary System header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Digestive System and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openIraqfWar,
			isOnIraqWarPage,
			function() {
				// go to Digestive System page
				ok($("a:contains('Digestive')" ).simulate("click"), "When I click the Digestive button");
				//check Digestive System header present
				ok($( 'h1:contains("Digestive System")' ).is(":visible"), "Digestive System header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
});
