define([
'jQuery',
'Underscore',
'asyncSeries',
'commonFunctions'

], function($$, Underscore, asyncSeries, commonFunctions) {

module("#1130 World War II");

//***** FUNCTIONS ******//

function openPhysicalHealthIssuesByEra() {
	// click the Physical Health Issues By Era button
	ok($( "#healthIssuesByEra" ).simulate("click"), "When I click the Physical Health Issues By Era button");
}

function isOnPhysicalHealthIssuesByEra() {
	ok($('h1:contains("Physical Health Issues By Era")' ).is(":visible"), "Physical Health Issues By Era is visible");
	ok($('h3:contains("World War")').is(":visible"), "World War button is visible");
}

function openWorldWarPage() {
	// click the World War II button
	ok($( 'h3:contains("World War II")' ).simulate("click"), "When I click the World War II button");
	
}

function isOnWorldWarPage() {
	// World War II header is visible and all buttons are visible
	ok($( 'h1:contains("World War II")' ).is(":visible"), "World War II is visible");
	ok($( 'a:contains("Cold Injury")' ).is(":visible"), "Cold Injury button is visible");
	ok($( 'a:contains("Noise")' ).is(":visible"), "Noise button is visible");
	ok($( 'a:contains("Occupational Hazards")' ).is(":visible"), "Occupational Hazards button is visible");
	ok($( 'a:contains("Ionizing Radiation")' ).is(":visible"), "Ionizing Radiation button is visible");
	ok($( 'a:contains("Chemical Warfare")' ).is(":visible"), "Chemical Warfare button is visible");
	
}

function isOnCommonVeteranIssuesPage() {
	// Common Veteran Issues header is visible
	ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues header is visible");
	
}



function isOnHomePage() {
	// Caring4WomenVeterans header is visible
	ok($( 'h1:contains("Caring4WomenVeterans")' ).is(":visible"), "Caring4WomenVeterans header is visible");
	ok($( 'a:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
}

function backButtonAndFooterArePresent() {
	// make sure the Back button is visible
	ok($(".ui-btn-text:contains('Back')").is(":visible"), "Back button is visible");
	
	var $footer = $("div[data-role='footer']");
	
	// make sure the footer is visible
	ok($footer.is(":visible"), "Footer is visible");
	
	// make sure all footer links are present
	ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
	ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
	ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
	ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
}

function clickBack() {
	// click the Back button
	ok($( ".ui-btn-text:contains('Back')" ).simulate("click"), "When I click the Back button");
}

// Navigate to the Common Veteran Issues Page
function navCommonHealth() {
	// starting on main page
	ok($( "#commonHealthIssues" ).is(":visible"), "Common Veteran Issues button is visible");
	ok($( "#commonHealthIssues" ).simulate("click"), "When I click the Common Veteran Issues button");
	ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
}
test("Navigate to Health Issues By Era page and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openWorldWarPage,
		isOnWorldWarPage,
		start
	);
});
test("Navigate to Cold Injury and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openWorldWarPage,
		isOnWorldWarPage,
		function() {
			// go to Cold Injury page
			ok($("a:contains('Cold Injury')" ).simulate("click"), "When I click the Cold Injury button");
			//check Chemical & Biological Weapons header present
			ok($( 'h1:contains("Cold Injury")' ).is(":visible"), "Cold Injury header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
	);
});
test("Navigate to Noise and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openWorldWarPage,
		isOnWorldWarPage,
		function() {
			// go to Noise page
			ok($("a:contains('Noise')" ).simulate("click"), "When I click the Noise button");
			//check Noise header present
			ok($( 'h1:contains("Noise")' ).is(":visible"), "Noise header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
	);
});
test("Navigate to Occupational Hazards and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openWorldWarPage,
		isOnWorldWarPage,
		function() {
			// go to Occupational Hazards page
			ok($("a:contains('Occupational Hazards')" ).simulate("click"), "When I click the Occupational Hazards button");
			//check Occupational Hazards header present
			ok($( 'h1:contains("Occupational Hazards")' ).is(":visible"), "Occupational Hazards header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
		);
	});
test("Navigate to Ionizing Radiation and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openWorldWarPage,
		isOnWorldWarPage,
		function() {
			// go to Occupational Hazards page
			ok($("a:contains('Ionizing Radiation')" ).simulate("click"), "When I click the Ionizing Radiation button");
			//check OIonizing Radiation header present
			ok($( 'h1:contains("Ionizing Radiation")' ).is(":visible"), "Ionizing Radiation header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
		);
	});
test("Navigate to Chemical Warfare and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openWorldWarPage,
		isOnWorldWarPage,
		function() {
			// go to Chemical Warfare page
			ok($("a:contains('Chemical Warfare')" ).simulate("click"), "When I click the Chemical Warfare button");
			//check Chemical Warfare header present
			ok($( 'h1:contains("Chemical Warfare")' ).is(":visible"), "Chemical Warfare header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
		);
	});
});
